/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.events.PrivateMessageEvent;
import pl.mirotcz.privatemessages.bukkit.sound.SoundConfiguration;
import pl.mirotcz.privatemessages.bukkit.utils.StringUtils;

public class MessageSending {
    public static void sendMessage(CommandSender sender, Player recipient, OfflinePlayer offlineRecipient, String recipientName, boolean offline, boolean vanish, String[] args) {
        String senderName;
        PrivateMessages instance = PrivateMessages.get();
        if (recipient == sender && !instance.getSettings().ALLOW_SENDING_MESSAGES_TO_SELF) {
            instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_CANNOT_MESSAGE_SELF);
            return;
        }
        if (recipient == null && offlineRecipient == null) {
            instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_PLAYER_NOT_FOUND);
            return;
        }
        boolean isSenderConsole = sender instanceof ConsoleCommandSender;
        String string = senderName = !isSenderConsole ? sender.getName() : instance.getMessages().CONSOLE_SENDER_NAME;
        if (!isSenderConsole) {
            PlayerSettings recipientSettings = instance.getManagers().getPlayerSettingsManager().getPlayerSettings(recipientName);
            PlayerSettings senderSettings = instance.getManagers().getPlayerSettingsManager().getPlayerSettings(senderName);
            if ((recipientSettings.getIgnoredPlayers().contains(senderName) || instance.getManagers().getIntegrationManager().isIgnoredOnSupportedIntegration(senderName, recipientName)) && !sender.hasPermission("pm.message.ignored")) {
                instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_PLAYER_IGNORES_YOU);
                return;
            }
            if ((senderSettings.getIgnoredPlayers().contains(recipientName) || instance.getManagers().getIntegrationManager().isIgnoredOnSupportedIntegration(recipientName, senderName)) && !sender.hasPermission("pm.message.ignored")) {
                instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_PLAYER_IGNORED);
                return;
            }
            if (!recipientSettings.arePrivateMessagesEnabled() && !sender.hasPermission("pm.message.disabled")) {
                instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_PLAYER_MESSAGES_DISABLED);
                return;
            }
            if (!senderSettings.arePrivateMessagesEnabled() && !sender.hasPermission("pm.message.disabled")) {
                instance.getMessenger().sendMessage(sender, instance.getMessages().INFO_MESSAGES_DISABLED);
                return;
            }
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 && args[i].equalsIgnoreCase(recipientName)) continue;
            text.append(args[i]);
            if (i + 1 >= args.length) continue;
            text.append(" ");
        }
        String final_text = StringUtils.getSafeString(text.toString());
        Message message = new Message(senderName, recipientName, System.currentTimeMillis(), final_text);
        boolean vanishBypass = false;
        if (!vanish) {
            if (!offline) {
                instance.getMessenger().sendMessageWithCustomPrefix(sender, "", instance.getMessages().MESSAGE_TO_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", senderName).replaceAll("<message>", message.getMessageContent()));
            } else {
                instance.getMessenger().sendMessageWithCustomPrefix(sender, "", instance.getMessages().MESSAGE_TO_OFFLINE_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", senderName).replaceAll("<message>", message.getMessageContent()));
            }
        } else if (sender.hasPermission("pm.vanishbypass")) {
            instance.getMessenger().sendMessageWithCustomPrefix(sender, "", instance.getMessages().MESSAGE_TO_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", senderName).replaceAll("<message>", message.getMessageContent()));
            vanishBypass = true;
        } else {
            instance.getMessenger().sendMessageWithCustomPrefix(sender, "", instance.getMessages().MESSAGE_TO_OFFLINE_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", senderName).replaceAll("<message>", message.getMessageContent()));
        }
        if (recipient != null && recipient.isOnline()) {
            if (!vanish || vanish && vanishBypass) {
                MessageSending.notifyRecipientMessage(message);
            } else if (instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                instance.getManagers().getPendingMessagesManager().addPendingUnreadMessage(message);
            }
        } else if (instance.getSettings().MESSAGES_HISTORY_ENABLED) {
            instance.getManagers().getPendingMessagesManager().addPendingUnreadMessage(message);
        }
        if (recipient != null) {
            instance.getManagers().getPlayerTempDataManger().getData(recipient.getName()).setLastMessageSender(senderName);
        }
        if (sender instanceof Player) {
            instance.getManagers().getPlayerTempDataManger().getData(((Player)sender).getName()).setLastMessageSender(recipientName);
        }
        if (instance.getSettings().MESSAGES_HISTORY_ENABLED) {
            instance.getManagers().getPendingMessagesManager().addPendingMessage(message);
        }
        Bukkit.getScheduler().runTask((Plugin)instance, () -> Bukkit.getPluginManager().callEvent((Event)new PrivateMessageEvent(message)));
    }

    public static void notifyRecipientMessage(Message message) {
        Player recipient = Bukkit.getPlayer((String)message.getRecipientName());
        PrivateMessages instance = PrivateMessages.get();
        if (recipient != null) {
            instance.getMessenger().sendMessageWithCustomPrefix((CommandSender)recipient, "", instance.getMessages().MESSAGE_FROM_FORMAT.replaceAll("<player>", message.getSenderName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
            PlayerSettings recipientSettings = instance.getManagers().getPlayerSettingsManager().getPlayerSettings(recipient.getName());
            if (!recipientSettings.isMessageNotificationSoundEnabled()) {
                return;
            }
            SoundConfiguration soundConfiguration = instance.getManagers().getSoundConfigurationsManager().getConfiguration(recipientSettings.getMessageNotificationSoundNumber());
            if (soundConfiguration == null) {
                PrivateMessages.get().getLogger().warning("Unknown message notification sound with ID " + recipientSettings.getMessageNotificationSoundNumber());
                return;
            }
            if (!instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION || recipient.hasPermission("pm.sound." + soundConfiguration.getId())) {
                instance.getSoundPlayer().play(recipient, soundConfiguration);
            }
            if (instance.getSettings().PLUGIN_TIPS && recipientSettings.arePluginTipsEnabled()) {
                if (instance.getSettings().PLUGIN_TIPS_MODE == 1) {
                    PlayerTempData recipientTempData = instance.getManagers().getPlayerTempDataManger().getData(recipient.getName());
                    if (!recipientTempData.hasReceivedPmSoundTip()) {
                        instance.getMessenger().sendMessage((CommandSender)recipient, instance.getMessages().INFO_SOUND_CHANGE_TIP);
                        recipientTempData.setReceivedPmSoundTip(true);
                    }
                } else {
                    int recipientSoundTipsCount = recipientSettings.getNotificationSoundTipsCount();
                    if (recipientSoundTipsCount < 1) {
                        instance.getMessenger().sendMessage((CommandSender)recipient, instance.getMessages().INFO_SOUND_CHANGE_TIP);
                        recipientSettings.setNotificationSoundTipsCount(recipientSoundTipsCount + 1);
                    }
                }
            }
        }
    }

    public static void soundNotifyPlayer(String player_name) {
        PrivateMessages instance = PrivateMessages.get();
        Player player = Bukkit.getPlayer((String)player_name);
        if (player != null) {
            PlayerSettings settings = instance.getManagers().getPlayerSettingsManager().getPlayerSettings(player.getName());
            if (!settings.isMessageNotificationSoundEnabled()) {
                return;
            }
            SoundConfiguration soundConfiguration = instance.getManagers().getSoundConfigurationsManager().getConfiguration(settings.getMessageNotificationSoundNumber());
            if (soundConfiguration != null) {
                PlayerTempData tempData;
                if (!instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION || player.hasPermission("pm.sound." + soundConfiguration.getId())) {
                    instance.getSoundPlayer().play(player, soundConfiguration);
                }
                if (instance.getSettings().PLUGIN_TIPS && settings.arePluginTipsEnabled() && !(tempData = instance.getManagers().getPlayerTempDataManger().getData(player.getName())).hasReceivedPmSoundTip()) {
                    instance.getMessenger().sendMessage((CommandSender)player, instance.getMessages().INFO_SOUND_CHANGE_TIP);
                    tempData.setReceivedPmSoundTip(true);
                }
            } else {
                PrivateMessages.get().getLogger().warning("Unknown message notification sound with number " + settings.getMessageNotificationSoundNumber());
            }
        }
    }
}

