/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;

public class NotifierTask {
    private PrivateMessages instance;
    private BukkitTask task = null;
    private volatile ConcurrentLinkedQueue<String> players_waiting_for_notification = new ConcurrentLinkedQueue();
    private volatile boolean task_active = false;

    public NotifierTask(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void start() {
        this.task_active = true;
        this.task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.instance, () -> {
            while (this.task_active) {
                Iterator<String> it = this.players_waiting_for_notification.iterator();
                while (it.hasNext()) {
                    String player_name = it.next();
                    int count = 0;
                    for (Message m : this.instance.getManagers().getPendingMessagesManager().getPendingUnreadMessages()) {
                        if (!m.getRecipientName().equalsIgnoreCase(player_name)) continue;
                        ++count;
                    }
                    int stored_unread_messages = this.instance.getStorage().getUnreadMessagesWithRecipient(player_name).size();
                    if ((count += stored_unread_messages) > 0) {
                        this.instance.getMessenger().sendMessage((CommandSender)Bukkit.getPlayer((String)player_name), this.instance.getMessages().INFO_YOU_HAVE_UNREAD_MESSAGES.replaceAll("<number>", String.valueOf(count)));
                    }
                    it.remove();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void stop() {
        this.task_active = false;
        if (this.task != null && Bukkit.getScheduler().isCurrentlyRunning(this.task.getTaskId())) {
            this.task.cancel();
        }
    }

    public void addPlayerWaitingForNotification(String name) {
        if (!this.players_waiting_for_notification.contains(name)) {
            this.players_waiting_for_notification.add(name);
        }
    }
}

