/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.bukkit.Metrics;
import pl.mirotcz.charts.SimplePie;
import pl.mirotcz.privatemessages.bukkit.NotifierTask;
import pl.mirotcz.privatemessages.bukkit.ProxyModeExternalDatabasePlayerSettingsReloaderTask;
import pl.mirotcz.privatemessages.bukkit.ProxyModePlayerSettingsLoaderTask;
import pl.mirotcz.privatemessages.bukkit.ProxyVanishNotifierTask;
import pl.mirotcz.privatemessages.bukkit.data.ConsoleSenderTempData;
import pl.mirotcz.privatemessages.bukkit.integration.IVanishProvider;
import pl.mirotcz.privatemessages.bukkit.inventories.AdventureInventoryCreator;
import pl.mirotcz.privatemessages.bukkit.inventories.InventoryCreator;
import pl.mirotcz.privatemessages.bukkit.inventories.LegacyInventoryCreator;
import pl.mirotcz.privatemessages.bukkit.inventories.MessagesInventory;
import pl.mirotcz.privatemessages.bukkit.items.AdventureItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.items.ItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.items.LegacyItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.managers.Managers;
import pl.mirotcz.privatemessages.bukkit.managers.MessagesManager;
import pl.mirotcz.privatemessages.bukkit.managers.SettingsManager;
import pl.mirotcz.privatemessages.bukkit.messaging.AdventureMessenger;
import pl.mirotcz.privatemessages.bukkit.messaging.LegacyChatMessenger;
import pl.mirotcz.privatemessages.bukkit.messaging.Messenger;
import pl.mirotcz.privatemessages.bukkit.sound.SoundPlayer;
import pl.mirotcz.privatemessages.bukkit.storage.Storage;
import pl.mirotcz.privatemessages.bukkit.storage.Storage_MySQL;

public final class PrivateMessages
extends JavaPlugin {
    private IVanishProvider vanish = null;
    private static PrivateMessages instance;
    private Managers managers;
    private volatile MessagesInventory global_history_inv = null;
    private volatile long last_global_history_inv_gen = 0L;
    private BukkitTask cache_task = null;
    private ProxyVanishNotifierTask bungee_vanish_task = null;
    private NotifierTask notifier_task = null;
    private Metrics metrics;
    private Messenger messenger;
    private InventoryCreator invCreator;
    private ItemMetaEditor itemMetaEditor;
    private ProxyModePlayerSettingsLoaderTask proxy_mode_player_settings_loader_task = null;
    private ProxyModeExternalDatabasePlayerSettingsReloaderTask proxy_mode_external_db_player_settings_reloader_task = null;
    private final ConsoleSenderTempData consoleSenderTempData = new ConsoleSenderTempData();
    private SoundPlayer soundPlayer = null;

    public void onEnable() {
        instance = this;
        this.managers = new Managers(instance);
        this.managers.load();
        this.setupMessenger();
        this.setupInventoryCreator();
        this.setupItemMetaEditor();
        this.getManagers().setupMenuManager();
        this.soundPlayer = new SoundPlayer(instance);
        if (!this.getManagers().getIntegrationManager().isVanishSupported()) {
            this.getLogger().info("Vanish provider not found! Vanish support disabled.");
        } else {
            this.getLogger().info("Vanish provider found! Using " + this.managers.getIntegrationManager().getUsedVanishPluginName());
            this.vanish = this.managers.getIntegrationManager().getVanish();
            this.getServer().getPluginManager().registerEvents((Listener)this.vanish, (Plugin)instance);
        }
        this.startCacheTask();
        if (PrivateMessages.instance.getSettings().PROXY) {
            this.bungee_vanish_task = new ProxyVanishNotifierTask(instance);
            this.bungee_vanish_task.startTask();
            if (this.getStorage() instanceof Storage_MySQL) {
                this.proxy_mode_external_db_player_settings_reloader_task = new ProxyModeExternalDatabasePlayerSettingsReloaderTask(instance);
                this.proxy_mode_external_db_player_settings_reloader_task.start();
                this.proxy_mode_player_settings_loader_task = new ProxyModePlayerSettingsLoaderTask(instance);
            }
        }
        this.notifier_task = new NotifierTask(instance);
        this.notifier_task.start();
        this.startMetricsIfEnabled();
    }

    public void onDisable() {
        this.getManagers().getIntegrationManager().stopEssentialsIgnoreDataToStorageTask();
        this.getManagers().getPlayerSettingsManager().savePendingChanges();
        this.getManagers().getPlayerSettingsManager().cancelSaveTask();
        this.getManagers().getPendingMessagesManager().savePendingMessagesToStorage();
        this.getManagers().getPendingMessagesManager().cancelSaveTask();
        this.getManagers().getStorageManager().getStorage().closePool();
        this.stopCacheTask();
        if (this.bungee_vanish_task != null) {
            this.bungee_vanish_task.stopTask();
        }
        if (this.proxy_mode_external_db_player_settings_reloader_task != null) {
            this.proxy_mode_external_db_player_settings_reloader_task.stop();
        }
        if (this.notifier_task != null) {
            this.notifier_task.stop();
        }
    }

    public static PrivateMessages get() {
        return instance;
    }

    public Managers getManagers() {
        return this.managers;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public InventoryCreator getInventoryCreator() {
        return this.invCreator;
    }

    public ItemMetaEditor getItemMetaEditor() {
        return this.itemMetaEditor;
    }

    public MessagesManager getMessages() {
        return this.managers.getMessagesManager();
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public ProxyModeExternalDatabasePlayerSettingsReloaderTask getSettingsReloaderTask() {
        return this.proxy_mode_external_db_player_settings_reloader_task;
    }

    public ProxyModePlayerSettingsLoaderTask getSettingsLoaderTask() {
        return this.proxy_mode_player_settings_loader_task;
    }

    public NotifierTask getNotifierTask() {
        return this.notifier_task;
    }

    public Storage getStorage() {
        return this.managers.getStorageManager().getStorage();
    }

    public SettingsManager getSettings() {
        return this.managers.getSettingsManager();
    }

    public IVanishProvider getVanish() {
        return this.managers.getIntegrationManager().getVanish();
    }

    public static boolean isMinecraftVersionAtLeast(String versionStr) {
        return PrivateMessages.compareVersions(PrivateMessages.getServerVersion(), versionStr) >= 0;
    }

    public static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }

    public static String getValidDefaultSoundsFileName() {
        switch (PrivateMessages.getServerVersion()) {
            case "1.7.2": 
            case "1.7.4": 
            case "1.7.5": 
            case "1.7.6": 
            case "1.7.7": 
            case "1.7.8": 
            case "1.7.9": 
            case "1.7.10": 
            case "1.8": 
            case "1.8.1": 
            case "1.8.2": 
            case "1.8.3": 
            case "1.8.4": 
            case "1.8.5": 
            case "1.8.6": 
            case "1.8.7": 
            case "1.8.8": 
            case "1.8.9": {
                return "sounds_1.7-1.8.yml";
            }
            case "1.9": 
            case "1.9.1": 
            case "1.9.2": 
            case "1.9.3": 
            case "1.9.4": 
            case "1.10": 
            case "1.10.1": 
            case "1.10.2": 
            case "1.11": 
            case "1.11.1": 
            case "1.11.2": {
                return "sounds_1.9-1.11.yml";
            }
            case "1.12": 
            case "1.12.1": 
            case "1.12.2": {
                return "sounds_1.12.yml";
            }
            case "1.13": 
            case "1.13.1": 
            case "1.13.2": {
                return "sounds_1.13.yml";
            }
            case "1.14": 
            case "1.14.1": 
            case "1.14.2": 
            case "1.14.3": 
            case "1.14.4": {
                return "sounds_1.14.yml";
            }
        }
        return "sounds.yml";
    }

    public ConsoleSenderTempData getConsoleSenderTempData() {
        return this.consoleSenderTempData;
    }

    public void setupMessenger() {
        this.messenger = this.getSettings().MINIMESSAGE_CHAT_FORMATTING ? new AdventureMessenger() : new LegacyChatMessenger();
        this.messenger.setDefaultPrefix(this.getMessages().PLUGIN_PREFIX);
    }

    public void setupInventoryCreator() {
        this.invCreator = this.getSettings().MINIMESSAGE_CHAT_FORMATTING ? new AdventureInventoryCreator() : new LegacyInventoryCreator();
    }

    public void setupItemMetaEditor() {
        this.itemMetaEditor = this.getSettings().MINIMESSAGE_CHAT_FORMATTING ? new AdventureItemMetaEditor() : new LegacyItemMetaEditor();
    }

    public static String getServerVersion() {
        String version;
        try {
            version = Bukkit.getBukkitVersion().split("-")[0];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return null;
        }
        return version;
    }

    public void setGlobalHistoryInv(MessagesInventory inv) {
        this.global_history_inv = inv;
    }

    public MessagesInventory getGlobalHistoryInv() {
        return this.global_history_inv;
    }

    public synchronized void setLastGlobalHistoryInvGen(long time) {
        this.last_global_history_inv_gen = time;
    }

    public long getLastGlobalHistoryInvGen() {
        return this.last_global_history_inv_gen;
    }

    public void startCacheTask() {
        this.cache_task = Bukkit.getScheduler().runTaskTimer((Plugin)instance, () -> {
            if (System.currentTimeMillis() - this.getLastGlobalHistoryInvGen() >= (long)(this.getSettings().GLOBAL_HISTORY_CACHE_TIME_SECONDS * 1000)) {
                this.clearMessagesCache();
            }
        }, 20L, 20L);
    }

    public void stopCacheTask() {
        if (this.cache_task != null) {
            this.cache_task.cancel();
        }
    }

    public void clearMessagesCache() {
        if (this.getGlobalHistoryInv() != null) {
            this.setGlobalHistoryInv(null);
        }
    }

    public boolean isPlayerAllowedToInteractWithPlugin(String player_name) {
        return !this.getSettingsLoaderTask().isPlayerWaitingForSettingsLoad(player_name);
    }

    private void startMetricsIfEnabled() {
        if (this.getSettings().METRICS) {
            this.metrics = new Metrics(instance, 6123);
            this.metrics.addCustomChart(new SimplePie("using_minimessage_chat_formatting", () -> String.valueOf(this.getSettings().MINIMESSAGE_CHAT_FORMATTING)));
            this.metrics.addCustomChart(new SimplePie("proxy_mode", () -> String.valueOf(this.getSettings().PROXY)));
            this.metrics.addCustomChart(new SimplePie("each_notification_sound_requires_permission", () -> String.valueOf(this.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION)));
            this.metrics.addCustomChart(new SimplePie("vanish_integration", () -> String.valueOf(this.getVanish() != null)));
        }
    }
}

