/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;
import pl.mirotcz.privatemessages.bukkit.managers.PlayerSettingsManager;

public class ProxyModeExternalDatabasePlayerSettingsReloaderTask {
    private PrivateMessages instance;
    private BukkitTask task = null;
    private volatile ConcurrentLinkedQueue<String> players_waiting_for_reload = new ConcurrentLinkedQueue();
    private volatile boolean task_active = false;

    public ProxyModeExternalDatabasePlayerSettingsReloaderTask(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void start() {
        this.task_active = true;
        PlayerSettingsManager manager = this.instance.getManagers().getPlayerSettingsManager();
        this.task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.instance, () -> {
            while (this.task_active) {
                Iterator<String> it = this.players_waiting_for_reload.iterator();
                while (it.hasNext()) {
                    String player_name = it.next();
                    PlayerSettings settings = manager.getPlayerSettings(player_name);
                    if (settings == null) continue;
                    manager.reloadSettings(player_name);
                    it.remove();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void stop() {
        this.task_active = false;
        if (this.task != null && Bukkit.getScheduler().isCurrentlyRunning(this.task.getTaskId())) {
            this.task.cancel();
        }
    }

    public void addPlayerWaitingForReload(String name) {
        if (!this.players_waiting_for_reload.contains(name)) {
            this.players_waiting_for_reload.add(name);
        }
    }
}

