/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;
import pl.mirotcz.privatemessages.bukkit.events.PlayerSettingsReadyEvent;

public class ProxyModePlayerSettingsLoaderTask {
    private PrivateMessages instance;
    private Map<String, BukkitTask> playersWaitingForSettingsLoad;

    public ProxyModePlayerSettingsLoaderTask(PrivateMessages plugin) {
        this.instance = plugin;
        this.playersWaitingForSettingsLoad = new HashMap<String, BukkitTask>();
    }

    public void addPlayer(String player_name) {
        if (!this.playersWaitingForSettingsLoad.containsKey(player_name)) {
            BukkitTask task = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.instance, () -> {
                int number_of_tries = 0;
                PlayerSettings settings = null;
                do {
                    ++number_of_tries;
                    this.instance.getManagers().getPlayerSettingsManager().loadFromStorage(player_name);
                    settings = this.instance.getStorage().getPlayerSettings(player_name);
                    if (settings == null) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (number_of_tries != 10) continue;
                        this.instance.getLogger().warning("Cannot load player settings from storage for player with name " + player_name + "! Did 10 attempts within 30 seconds.");
                        this.instance.getLogger().warning("Plugin is configured to run in proxy mode ('Proxy: true') so all data for this player should already be created and saved to database from PrivateMessages plugin running proxy server. This is not the case or we have connection issues.");
                        this.instance.getLogger().warning("Please check if plugin is correctly configured both on proxy and backend servers, look at database connection settings and database server setup");
                        this.instance.getLogger().warning("Plugin will continue to work but player " + player_name + " won't be able to interact with PrivateMessages.");
                        break;
                    }
                    Bukkit.getScheduler().runTask((Plugin)this.instance, () -> Bukkit.getPluginManager().callEvent((Event)new PlayerSettingsReadyEvent(player_name)));
                } while (settings == null);
            }, 20L);
            this.playersWaitingForSettingsLoad.put(player_name, task);
        }
    }

    public void removePlayer(String player_name) {
        BukkitTask task;
        if (this.playersWaitingForSettingsLoad.containsKey(player_name) && (task = this.playersWaitingForSettingsLoad.get(player_name)) != null && Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId())) {
            task.cancel();
        }
        this.playersWaitingForSettingsLoad.remove(player_name);
    }

    public boolean isPlayerWaitingForSettingsLoad(String player_name) {
        return this.playersWaitingForSettingsLoad.containsKey(player_name);
    }
}

