/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.managers.IntegrationsManager;
import pl.mirotcz.privatemessages.bukkit.storage.Storage_MySQL;

public class ProxyVanishNotifierTask {
    private BukkitTask task = null;
    private PrivateMessages instance;

    public ProxyVanishNotifierTask(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void startTask() {
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, () -> {
            IntegrationsManager vanish = this.instance.getManagers().getIntegrationManager();
            Storage_MySQL storage = (Storage_MySQL)this.instance.getStorage();
            for (Player pl : Bukkit.getOnlinePlayers()) {
                boolean vanished = vanish.isVanishSupported() && vanish.getVanish().isVanished(pl);
                if (!vanished) continue;
                storage.sendVanishedPlayerInfo(pl.getName());
            }
        }, 100L, 100L);
    }

    public void stopTask() {
        if (this.task != null && Bukkit.getScheduler().isCurrentlyRunning(this.task.getTaskId())) {
            this.task.cancel();
        }
    }
}

