/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.ConsoleSenderTempData;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;

public class ConfirmCommand {
    private PrivateMessages instance;

    public ConfirmCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.confirm")) {
            if (args.length < 1) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_PMCONFIRM);
                return;
            }
            switch (args[0].toUpperCase()) {
                case "DELETE": {
                    this.proceedDeletion(sender);
                    break;
                }
                default: {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_PMCONFIRM);
                    return;
                }
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
        }
    }

    private void proceedDeletion(CommandSender sender) {
        List<Message> messages;
        if (!sender.hasPermission("pm.delete")) {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            return;
        }
        PlayerTempData tempData = null;
        ConsoleSenderTempData consoleTempData = null;
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            tempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getName());
            messages = tempData.getMessagesAwaitingDeletionConfirmation();
        } else {
            consoleTempData = this.instance.getConsoleSenderTempData();
            messages = consoleTempData.getMessagesAwaitingDeletionConfirmation();
        }
        if (messages == null) {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_DELETE_CONFIRMATION_NO_MESSAGES);
            return;
        }
        this.instance.getStorage().deleteMessages(messages);
        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", String.valueOf(messages.size())));
        if (tempData != null) {
            tempData.setMessagesAwaitingDeletionConfirmation(null);
        }
        if (consoleTempData != null) {
            consoleTempData.setMessagesAwaitingDeletionConfirmation(null);
        }
    }
}

