/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.MessagesRetrievalResult;
import pl.mirotcz.privatemessages.bukkit.inventories.MessagesInventory;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;
import pl.mirotcz.privatemessages.bukkit.utils.StringUtils;

public class HistoryCommand {
    private PrivateMessages instance;

    public HistoryCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.history")) {
            if (!PrivateMessages.get().getSettings().MESSAGES_HISTORY_ENABLED) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_MESSAGES_HISTORY_DISABLED);
                return;
            }
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            boolean global_history = false;
            if (pl.isSleeping()) {
                return;
            }
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_PLEASE_WAIT);
            List<Object> messages = new ArrayList();
            if (args.length == 0) {
                messages = PrivateMessages.get().getStorage().getMessagesFromHistory(pl.getName());
            } else if (args.length == 1) {
                messages = PrivateMessages.get().getStorage().getMessagesFromHistory(pl.getName(), args[0]);
            } else if (args.length >= 2) {
                if (!args[0].equalsIgnoreCase("-query") && !args[0].equalsIgnoreCase("-q")) {
                    if (args.length > 2) {
                        this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().HELP_COMMAND_PMHISTORY);
                        return;
                    }
                    if (args[0].equalsIgnoreCase("*") && args[1].equalsIgnoreCase("*")) {
                        if (!sender.hasPermission("pm.admin")) {
                            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        global_history = true;
                        if (PrivateMessages.get().getGlobalHistoryInv() == null) {
                            messages = PrivateMessages.get().getStorage().getMessagesFromHistory();
                        }
                    } else if (args[1].equalsIgnoreCase("*")) {
                        if (!sender.hasPermission("pm.admin")) {
                            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistory(args[0]);
                    } else {
                        if (!(args[0].equalsIgnoreCase(sender.getName()) || args[1].equalsIgnoreCase(sender.getName()) || sender.hasPermission("pm.admin"))) {
                            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistory(args[0], args[1]);
                    }
                } else {
                    if (!sender.hasPermission("pm.admin")) {
                        this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
                        return;
                    }
                    StringBuilder expression = new StringBuilder();
                    for (int i = 1; i < args.length; ++i) {
                        expression.append(args[i]);
                        if (i + 1 >= args.length) continue;
                        expression.append(" ");
                    }
                    MessagesRetrievalResult result = MainUtils.getMessagesMatchingExpression(expression.toString());
                    if (result.hasError()) {
                        switch (result.getError()) {
                            case INVALID_DATETIME_FORMAT: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_DATETIME_FORMAT.replaceAll("<format>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
                                break;
                            }
                            case INVALID_EXPRESSION: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_EXPRESSION);
                                break;
                            }
                            case INVALID_MESSAGE_ID: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_MESSAGE_ID);
                            }
                        }
                        return;
                    }
                    messages = result.getMessages();
                    if (result.containsAllStoredMessages()) {
                        global_history = true;
                    }
                }
            }
            MessagesInventory inv = null;
            boolean from_cache = false;
            if (global_history && PrivateMessages.get().getGlobalHistoryInv() != null) {
                from_cache = true;
                inv = PrivateMessages.get().getGlobalHistoryInv();
            } else {
                if (messages.isEmpty()) {
                    this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_MESSAGES);
                    return;
                }
                inv = new MessagesInventory(PrivateMessages.get(), messages, pl);
                inv.load();
                inv.addExtraPageItems();
            }
            if (global_history && !from_cache) {
                PrivateMessages.get().setGlobalHistoryInv(inv);
                PrivateMessages.get().setLastGlobalHistoryInvGen(System.currentTimeMillis());
            }
            MessagesInventory f_inv = inv;
            PrivateMessages.get().getManagers().getPlayerTempDataManger().getData(pl.getName()).setLastMessagesInventory(inv);
            Bukkit.getScheduler().runTask((Plugin)PrivateMessages.get(), () -> {
                PlayerStates.setState(pl, PlayerStates.State.WAITING_MESSAGES_HISTORY);
                pl.openInventory(f_inv.get(1));
            });
        } else {
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
        }
    }
}

