/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import java.util.List;
import org.bukkit.command.CommandSender;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;

public class MigrateCommand {
    private PrivateMessages instance;

    public MigrateCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.migrate")) {
            if (args.length < 2) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_PMMIGRATE);
                return;
            }
            String oldName = args[0];
            String newName = args[1];
            boolean force = args.length >= 3 && args[2].equals("--force");
            PlayerSettings oldPlayerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(oldName);
            if (oldPlayerSettings == null) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PLAYER_DATA.replaceAll("<player>", oldName));
                return;
            }
            if (this.instance.getManagers().getPlayerSettingsManager().playerSettingsExists(newName) && !force) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_DATA_EXISTS.replaceAll("<player>", newName));
                return;
            }
            List<Message> newNameMessages = this.instance.getStorage().getMessagesFromHistory(newName);
            if (!newNameMessages.isEmpty() && !force) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_DATA_EXISTS.replaceAll("<player>", newName));
                return;
            }
            oldPlayerSettings.setPlayerName(newName);
            this.instance.getManagers().getPlayerSettingsManager().removePlayerData(oldName);
            this.instance.getStorage().removePlayerSettings(newName);
            this.instance.getStorage().deletePlayerMessages(newName);
            List<Message> oldNameMessages = this.instance.getStorage().getMessagesFromHistory(oldName);
            if (!oldNameMessages.isEmpty()) {
                oldNameMessages.forEach(message -> {
                    if (message.getSenderName().equalsIgnoreCase(oldName)) {
                        message.setSenderName(newName);
                    } else {
                        message.setRecipientName(newName);
                    }
                });
                oldNameMessages.forEach(message -> this.instance.getStorage().saveMessage((Message)message));
            }
            List<Message> pending_messages = this.instance.getManagers().getPendingMessagesManager().getPendingMessages();
            pending_messages.forEach(message -> {
                if (message.getSenderName().equalsIgnoreCase(oldName)) {
                    message.setSenderName(newName);
                } else {
                    message.setRecipientName(newName);
                }
            });
            List<Message> pending_offline_messages = this.instance.getManagers().getPendingMessagesManager().getPendingUnreadMessages();
            pending_offline_messages.forEach(message -> {
                if (message.getSenderName().equalsIgnoreCase(oldName)) {
                    message.setSenderName(newName);
                } else {
                    message.setRecipientName(newName);
                }
            });
            List<Message> unread_messages = this.instance.getStorage().getUnreadMessagesWithRecipient(oldName);
            unread_messages.forEach(message -> message.setRecipientName(newName));
            unread_messages.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            List<Message> unread_messages_sender = this.instance.getStorage().getUnreadMessagesWithSender(oldName);
            unread_messages_sender.forEach(message -> message.setSenderName(newName));
            unread_messages_sender.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MIGRATE_SUCCESS.replaceAll("<oldName>", oldName).replaceAll("<newName>", newName));
        } else {
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
        }
    }
}

