/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;

public class ReadCommand {
    private PrivateMessages instance;

    public ReadCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.read")) {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            if (args.length != 1) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().HELP_COMMAND_PMREAD);
                return;
            }
            if (!MainUtils.isInteger(args[0])) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_INVALID_NUMBER);
                return;
            }
            int number = Integer.parseInt(args[0]);
            List<Message> stored_messages = PrivateMessages.get().getStorage().getUnreadMessagesWithRecipient(pl.getName());
            List<Message> all_pending_messages = PrivateMessages.get().getManagers().getPendingMessagesManager().getPendingUnreadMessages();
            ArrayList<Message> all_messages = new ArrayList<Message>();
            for (int i = all_pending_messages.size() - 1; i >= 0; --i) {
                Message m = all_pending_messages.get(i);
                if (!m.getRecipientName().equalsIgnoreCase(pl.getName())) continue;
                all_messages.add(m);
            }
            all_messages.addAll(stored_messages);
            if (all_messages.isEmpty()) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_MESSAGES);
                return;
            }
            if (all_messages.size() < number) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_MESSAGE_NOT_FOUND);
                return;
            }
            Message message = (Message)all_messages.get(number - 1);
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_MESSAGE_READ_NUMBER.replaceAll("<number>", String.valueOf(number)));
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_MESSAGE_READ_SENDER.replaceAll("<sender>", message.getSenderName()));
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_MESSAGE_READ_MESSAGE.replaceAll("<message>", message.getMessageContent()));
            PlayerSettings player_settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getName());
            if (this.instance.getSettings().PLUGIN_TIPS && player_settings.arePluginTipsEnabled()) {
                if (this.instance.getSettings().PLUGIN_TIPS_MODE == 1) {
                    PlayerTempData recipientTempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getName());
                    if (!recipientTempData.hasReceivedPmClearTip()) {
                        this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_CLEAR_MESSAGES_TIP);
                        recipientTempData.setReceivedPmClearTip(true);
                    }
                } else {
                    PlayerSettings recipientSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getName());
                    int unreadMessagesTipsCount = recipientSettings.getUnreadMessagesTipsCount();
                    if (unreadMessagesTipsCount < 1) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_CLEAR_MESSAGES_TIP);
                        recipientSettings.setUnreadMessagesTipsCount(unreadMessagesTipsCount + 1);
                    }
                }
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
        }
    }
}

