/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.mirotcz.privatemessages.bukkit.MessageSending;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;

public class ReplyCommand {
    private PrivateMessages instance;

    public ReplyCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.reply")) {
            if (args.length < 1) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_REPLY);
                return;
            }
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            PlayerTempData data = this.instance.getManagers().getPlayerTempDataManger().getData(((Player)sender).getName());
            if (data.getLastMessageSender() == null) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NONE_TO_REPLY);
                return;
            }
            Player pl = Bukkit.getPlayer((String)data.getLastMessageSender());
            OfflinePlayer op = null;
            String recipientName = null;
            boolean offline = false;
            boolean vanish = false;
            if (pl == null || !pl.isOnline()) {
                if (this.instance.getSettings().ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS && this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                    op = MainUtils.getOfflinePlayer(data.getLastMessageSender(), Bukkit.getOfflinePlayers());
                    if (op != null) {
                        recipientName = op.getName();
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OFFLINE_MESSAGING_DISABLED);
                    return;
                }
                offline = true;
            } else {
                if (!offline && sender instanceof Player && !((Player)sender).canSee(pl)) {
                    vanish = true;
                }
                if (offline) {
                    if (this.instance.getSettings().ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS && this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                        op = MainUtils.getOfflinePlayer(args[0], Bukkit.getOfflinePlayers());
                        if (op != null) {
                            recipientName = op.getName();
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OFFLINE_MESSAGING_DISABLED);
                        return;
                    }
                }
                recipientName = pl.getName();
                if (this.instance.getManagers().getIntegrationManager().isVanishSupported() && this.instance.getManagers().getIntegrationManager().getVanish().isVanished(pl)) {
                    vanish = true;
                }
            }
            MessageSending.sendMessage(sender, pl, op, recipientName, offline, vanish, args);
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }
}

