/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.commands;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.InventoryLoadResult;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.inventories.SoundInventory;

public class SoundCommand {
    private PrivateMessages instance;

    public SoundCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("pm.sound")) {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getName());
            SoundInventory soundInv = tempData.getLastSoundInventory();
            if (soundInv == null) {
                SoundInventory loadedSoundInv = new SoundInventory(this.instance, pl);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.instance, () -> {
                    if (loadedSoundInv.load() != InventoryLoadResult.SUCCESS) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_GENERIC_ERROR);
                        return;
                    }
                    tempData.setLastSoundInventory(loadedSoundInv);
                    this.sendSoundInvOnNextTick(pl, loadedSoundInv);
                });
            } else {
                this.sendSoundInvOnNextTick(pl, soundInv);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, PrivateMessages.get().getMessages().INFO_NO_PERMISSION);
        }
    }

    private void sendSoundInvOnNextTick(Player pl, SoundInventory soundInventory) {
        Bukkit.getScheduler().runTask((Plugin)PrivateMessages.get(), () -> {
            PlayerStates.setState(pl, PlayerStates.State.WAITING_SOUND_INVENTORY);
            pl.openInventory(soundInventory.get(1));
        });
    }
}

