/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.Caller;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.InventoryLoadResult;
import pl.mirotcz.privatemessages.bukkit.inventories.Menu;
import pl.mirotcz.privatemessages.bukkit.inventories.MessagesInventory;
import pl.mirotcz.privatemessages.bukkit.items.ItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.utils.InventoryEventUtils;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;

public class MessageActionsInventory
implements Menu {
    private PrivateMessages instance = null;
    private Message message = null;
    private Player player = null;
    private List<Inventory> pages = new ArrayList<Inventory>();
    String p1;
    String p2;
    private int parentMessageItemIndex = 0;
    private Inventory parentMessagesView = null;
    private MessagesInventory parentMessagesInv = null;
    private boolean deletionConfirmed = false;

    public MessageActionsInventory(PrivateMessages plugin, Message message, Inventory parentMessagesView, MessagesInventory parentMessagesInv, int parentMessageItemIndex, Player player) {
        this.instance = plugin;
        this.parentMessagesView = parentMessagesView;
        this.parentMessagesInv = parentMessagesInv;
        this.parentMessageItemIndex = parentMessageItemIndex;
        this.message = message;
        this.player = player;
    }

    public static boolean isValidInventory(InventoryClickEvent e) {
        if (InventoryEventUtils.getClickedInventory(e).getSize() != 9) {
            return false;
        }
        if (e.getView().getTitle() == null) {
            return false;
        }
        return e.getView().getTitle().equals(PrivateMessages.get().getMessages().INV_MESSAGE_ACTIONS_TITLE);
    }

    public static boolean isValidInventory(Inventory inv, String title) {
        if (inv.getSize() != 9) {
            return false;
        }
        if (title == null) {
            return false;
        }
        return title.equals(PrivateMessages.get().getMessages().INV_MESSAGE_ACTIONS_TITLE);
    }

    private ItemStack getMessageDeleteItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().MESSAGE_ACTION_DELETE_ITEM_MATERIAL);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_MESSAGE_ACTIONS_DELETE_MESSAGE_ITEM_DISPLAYNAME);
        itemMeta = itemMetaEditor.setLore(itemMeta, this.instance.getMessages().INV_MESSAGE_ACTIONS_DELETE_MESSAGE_ITEM_LORE);
        is.setItemMeta(itemMeta);
        return is;
    }

    private ItemStack getBackToMessagesItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().BACK_ITEM);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_BACK_ITEM_DISPLAYNAME);
        is.setItemMeta(itemMeta);
        return is;
    }

    @Override
    public InventoryLoadResult load() {
        Inventory inv = this.instance.getInventoryCreator().createInventory(null, 9, this.instance.getMessages().INV_MESSAGE_ACTIONS_TITLE);
        this.pages = new ArrayList<Inventory>();
        HashMap<Integer, Caller> leftPageCallers = new HashMap<Integer, Caller>();
        HashMap rightPageCallers = new HashMap();
        this.addMessageItem(inv);
        this.addBackToMessagesItem(inv, leftPageCallers);
        if (this.player.hasPermission("pm.actions.delete")) {
            this.addDeleteMessageItem(inv, leftPageCallers);
        }
        leftClickCallers.put(inv, leftPageCallers);
        rightClickCallers.put(inv, rightPageCallers);
        this.pages.add(inv);
        return InventoryLoadResult.SUCCESS;
    }

    private void addBackToMessagesItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
            PlayerStates.setState(player, PlayerStates.State.SWITCHING_INVENTORY);
            player.closeInventory();
            Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                PlayerStates.setState(player, PlayerStates.State.WAITING_MESSAGES_HISTORY);
                player.openInventory(this.parentMessagesView);
            });
        });
        leftPageCallers.put(8, left);
        inv.setItem(8, this.getBackToMessagesItem());
    }

    private void addDeleteMessageItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        ItemStack deleteItem = this.getMessageDeleteItem();
        Caller left = player -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.instance, () -> {
            if (!player.hasPermission("pm.actions.delete")) {
                this.instance.getMessenger().sendMessage((CommandSender)player, this.instance.getMessages().INFO_NO_PERMISSION);
                Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    PlayerStates.setState(player, PlayerStates.State.CLOSING_GUI);
                    player.closeInventory();
                    if (this.parentMessagesInv.hasAnyItem()) {
                        Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> {
                            PlayerStates.setState(player, PlayerStates.State.WAITING_MESSAGES_HISTORY);
                            player.openInventory(this.parentMessagesView);
                        }, 10L);
                    }
                });
                return;
            }
            if (this.instance.getSettings().MESSAGES_DELETION_BY_INVENTORY_REQUIRES_CONFIRMATION && !this.deletionConfirmed) {
                Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    this.deletionConfirmed = true;
                    ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
                    ItemMeta itemMeta = deleteItem.getItemMeta();
                    List lore = itemMeta.getLore();
                    lore.addAll(this.instance.getMessages().INV_MESSAGE_ACTIONS_DELETE_MESSAGE_ITEM_LORE_CONFIRMATION);
                    itemMeta = itemMetaEditor.setLore(itemMeta, lore);
                    deleteItem.setItemMeta(itemMeta);
                    inv.setItem(4, deleteItem);
                });
                return;
            }
            this.instance.getStorage().deleteMessage(this.message.getId());
            Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                PlayerStates.setState(player, PlayerStates.State.CLOSING_GUI);
                player.closeInventory();
                this.instance.getMessenger().sendMessage((CommandSender)player, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", "1"));
                this.parentMessagesInv.deleteItem(this.parentMessagesView, this.parentMessageItemIndex);
                PrivateMessages.get().getManagers().getPlayerTempDataManger().getData(player.getName()).setLastMessageActionsInventory(null);
                if (this.parentMessagesInv.hasAnyItem()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> {
                        PlayerStates.setState(player, PlayerStates.State.WAITING_MESSAGES_HISTORY);
                        player.openInventory(this.parentMessagesView);
                    }, 10L);
                } else {
                    PlayerStates.setState(player, PlayerStates.State.IDLE);
                    PrivateMessages.get().getManagers().getPlayerTempDataManger().getData(player.getName()).setLastMessagesInventory(null);
                }
            });
        });
        leftPageCallers.put(4, left);
        inv.setItem(4, deleteItem);
    }

    private void addMessageItem(Inventory inv) {
        ItemStack messageItem = MainUtils.getMessageItem(this.message);
        inv.setItem(0, messageItem);
    }

    public Map<Inventory, Map<Integer, Caller>> getLeftClickCallers() {
        return leftClickCallers;
    }

    public Map<Inventory, Map<Integer, Caller>> getRightClickCallers() {
        return rightClickCallers;
    }

    @Override
    public Caller getLeftClickCaller(Inventory inv, int slot) {
        Map callers;
        if (leftClickCallers.containsKey(inv) && (callers = (Map)leftClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (rightClickCallers.containsKey(inv) && (callers = (Map)rightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getShiftRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (shiftRightClickCallers.containsKey(inv) && (callers = (Map)shiftRightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Inventory get(int page) {
        if (this.pages.size() >= page) {
            return this.pages.get(page - 1);
        }
        return null;
    }

    @Override
    public List<Inventory> getPages() {
        return this.pages;
    }
}

