/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.inventories;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.Caller;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.InventoryLoadResult;
import pl.mirotcz.privatemessages.bukkit.inventories.Menu;
import pl.mirotcz.privatemessages.bukkit.inventories.MessageActionsInventory;
import pl.mirotcz.privatemessages.bukkit.items.ItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.utils.InventoryEventUtils;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;

public class MessagesInventory
implements Menu {
    private PrivateMessages instance = null;
    private List<Message> messages = null;
    private List<Inventory> pages = new ArrayList<Inventory>();
    private Player requesting_player = null;
    Inventory inv;
    String p1;
    String p2;
    private DateTimeFormatter formatter = null;
    private volatile long time;
    private volatile int a_count = 0;
    private volatile int t_count = 0;
    ItemStack nextpage;
    ItemStack previouspage;

    public MessagesInventory(PrivateMessages plugin, List<Message> msg, Player requesting_player) {
        this.instance = plugin;
        this.messages = msg;
        this.formatter = this.instance.getSettings().MESSAGES_HISTORY_DATETIME_FORMATTER;
        this.requesting_player = requesting_player;
    }

    public static boolean isValidInventory(InventoryClickEvent e) {
        if (InventoryEventUtils.getClickedInventory(e).getSize() != 54) {
            return false;
        }
        if (e.getView().getTitle() == null) {
            return false;
        }
        return e.getView().getTitle().equals(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_TITLE);
    }

    public static boolean isValidInventory(Inventory inv, String title) {
        if (inv.getSize() != 54) {
            return false;
        }
        if (title == null) {
            return false;
        }
        return title.equals(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_TITLE);
    }

    @Override
    public InventoryLoadResult load() {
        Inventory inv = this.instance.getInventoryCreator().createInventory(null, 54, this.instance.getMessages().INV_MESSAGES_HISTORY_TITLE);
        this.pages = new ArrayList<Inventory>();
        int count = 0;
        int pagesCount = 1;
        this.a_count = 0;
        this.t_count = 0;
        Iterator<Message> it = this.messages.iterator();
        HashMap<Integer, Caller> leftPageCallers = new HashMap<Integer, Caller>();
        HashMap rightPageCallers = new HashMap();
        this.time = System.currentTimeMillis();
        long part_duration = 0L;
        while (it.hasNext()) {
            long end;
            HashMap finalRightPageCallers;
            long start = System.currentTimeMillis();
            ++this.a_count;
            ++this.t_count;
            long current_time = System.currentTimeMillis();
            if (this.t_count >= this.instance.getSettings().MAX_HISTORY_MESSAGES_PER_SECOND && part_duration >= 1000L || this.t_count >= this.instance.getSettings().MAX_HISTORY_MESSAGES_PER_SECOND && current_time - this.time <= 1000L) {
                if (part_duration > 1000L) {
                    try {
                        Thread.sleep(part_duration - 1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Thread.sleep(1000L - (current_time - this.time));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.requesting_player != null && this.requesting_player.isOnline()) {
                    this.instance.getMessenger().sendMessage((CommandSender)this.requesting_player, PrivateMessages.get().getMessages().INFO_PLEASE_WAIT + " " + (int)MainUtils.round((double)this.a_count / (double)this.messages.size() * 100.0, 2) + "%");
                }
                this.t_count = 0;
                this.time = System.currentTimeMillis();
                part_duration = 0L;
            }
            Message message = it.next();
            if (this.requesting_player.hasPermission("pm.actions")) {
                Inventory f_inv = inv;
                int f_count = count;
                Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    PlayerStates.setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                    player.closeInventory();
                    Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                        MessageActionsInventory maInv = new MessageActionsInventory(this.instance, message, f_inv, this, f_count, player);
                        maInv.load();
                        PrivateMessages.get().getManagers().getPlayerTempDataManger().getData(player.getName()).setLastMessageActionsInventory(maInv);
                        PlayerStates.setState(player, PlayerStates.State.WAITING_MESSAGE_ACTIONS);
                        player.openInventory(maInv.get(1));
                    });
                });
                leftPageCallers.put(count, left);
            }
            ItemStack messageItem = MainUtils.getMessageItem(message, this.requesting_player, true);
            inv.setItem(count, messageItem);
            if (!it.hasNext() || count == 44) {
                this.addExitItem(inv, leftPageCallers);
                if (pagesCount > 1) {
                    this.addPreviousPageItem(inv, pagesCount - 1, 45, 1, leftPageCallers);
                }
            }
            if (!it.hasNext()) {
                this.pages.add(inv);
                HashMap<Integer, Caller> finalLeftPageCallers = new HashMap<Integer, Caller>(leftPageCallers);
                finalRightPageCallers = new HashMap(rightPageCallers);
                leftClickCallers.put(inv, finalLeftPageCallers);
                rightClickCallers.put(inv, finalRightPageCallers);
                end = System.currentTimeMillis();
                part_duration += end - start;
                return InventoryLoadResult.SUCCESS;
            }
            if (count == 44) {
                this.addNextPageItem(inv, pagesCount + 1, 53, 1, leftPageCallers);
                this.pages.add(inv);
                HashMap<Integer, Caller> finalLeftPageCallers = new HashMap<Integer, Caller>(leftPageCallers);
                finalRightPageCallers = new HashMap(rightPageCallers);
                leftClickCallers.put(inv, finalLeftPageCallers);
                rightClickCallers.put(inv, finalRightPageCallers);
                leftPageCallers = new HashMap();
                rightPageCallers = new HashMap();
                ++pagesCount;
                count = 0;
                inv = this.instance.getInventoryCreator().createInventory(null, 54, this.instance.getMessages().INV_MESSAGES_HISTORY_TITLE);
                end = System.currentTimeMillis();
                part_duration += end - start;
                continue;
            }
            long end2 = System.currentTimeMillis();
            part_duration += end2 - start;
            ++count;
        }
        return InventoryLoadResult.SUCCESS;
    }

    private ItemStack getExitItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().EXIT_ITEM);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_EXIT_ITEM_DISPLAYNAME);
        is.setItemMeta(itemMeta);
        return is;
    }

    private void addExitItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
            PlayerStates.setState(player, PlayerStates.State.CLOSING_GUI);
            player.closeInventory();
            PlayerStates.setState(player, PlayerStates.State.IDLE);
        });
        leftPageCallers.put(inv.getSize() - 5, left);
        inv.setItem(inv.getSize() - 5, this.getExitItem());
    }

    public void addNextPageItem(Inventory inv, int nextPageNumber, int slot, int itemCount, Map<Integer, Caller> leftPageCallers) {
        ItemStack nextPageItem = new ItemStack(Material.ARROW);
        ItemMeta pageItemMeta = nextPageItem.getItemMeta();
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        pageItemMeta = itemMetaEditor.setDisplayName(pageItemMeta, this.instance.getMessages().INV_NEXT_PAGE);
        ArrayList<String> pageItemLore = new ArrayList<String>();
        pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(nextPageNumber)));
        pageItemMeta = itemMetaEditor.setLore(pageItemMeta, pageItemLore);
        nextPageItem.setItemMeta(pageItemMeta);
        nextPageItem.setAmount(itemCount);
        Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> player.openInventory(this.get(nextPageNumber)));
        leftPageCallers.put(slot, left);
        inv.setItem(slot, nextPageItem);
    }

    public void addPreviousPageItem(Inventory inv, int previousPageNumber, int slot, int itemCount, Map<Integer, Caller> leftPageCallers) {
        ItemStack previousPageItem = new ItemStack(Material.ARROW);
        ItemMeta pageItemMeta = previousPageItem.getItemMeta();
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        pageItemMeta = itemMetaEditor.setDisplayName(pageItemMeta, this.instance.getMessages().INV_PREVIOUS_PAGE);
        ArrayList<String> pageItemLore = new ArrayList<String>();
        pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(previousPageNumber)));
        pageItemMeta = itemMetaEditor.setLore(pageItemMeta, pageItemLore);
        previousPageItem.setItemMeta(pageItemMeta);
        previousPageItem.setAmount(itemCount);
        Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> player.openInventory(this.get(previousPageNumber)));
        leftPageCallers.put(slot, left);
        inv.setItem(slot, previousPageItem);
    }

    public void addExtraPageItems() {
        for (int i = 1; i <= this.pages.size(); ++i) {
            Inventory inv = this.pages.get(i - 1);
            Map leftPageCallers = (Map)leftClickCallers.get(inv);
            Map rightPageCallers = (Map)rightClickCallers.get(inv);
            if (i - 10 > 0) {
                this.addPreviousPageItem(inv, i - 10, 46, 10, leftPageCallers);
            }
            if (i + 10 <= this.pages.size()) {
                this.addNextPageItem(inv, i + 10, 52, 10, leftPageCallers);
            }
            if (i - 50 > 0) {
                this.addPreviousPageItem(inv, i - 50, 47, 50, leftPageCallers);
            }
            if (i + 50 <= this.pages.size()) {
                this.addNextPageItem(inv, i + 50, 51, 50, leftPageCallers);
            }
            HashMap finalLeftPageCallers = new HashMap(leftPageCallers);
            HashMap finalRightPageCallers = new HashMap(rightPageCallers);
            leftClickCallers.put(inv, finalLeftPageCallers);
            rightClickCallers.put(inv, finalRightPageCallers);
        }
    }

    public Map<Inventory, Map<Integer, Caller>> getLeftClickCallers() {
        return leftClickCallers;
    }

    public Map<Inventory, Map<Integer, Caller>> getRightClickCallers() {
        return rightClickCallers;
    }

    @Override
    public Caller getLeftClickCaller(Inventory inv, int slot) {
        Map callers;
        if (leftClickCallers.containsKey(inv) && (callers = (Map)leftClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (rightClickCallers.containsKey(inv) && (callers = (Map)rightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    public void deleteItem(Inventory inv, int slot) {
        Map callers;
        if (inv == null) {
            return;
        }
        inv.setItem(slot, null);
        if (leftClickCallers.containsKey(inv)) {
            callers = (Map)leftClickCallers.get(inv);
            if (callers.containsKey(slot)) {
                callers.remove(slot);
            }
            if (callers.size() == 0) {
                leftClickCallers.remove(inv);
            }
        }
        if (rightClickCallers.containsKey(inv)) {
            callers = (Map)rightClickCallers.get(inv);
            if (callers.containsKey(slot)) {
                callers.remove(slot);
            }
            if (callers.size() == 0) {
                rightClickCallers.remove(inv);
            }
        }
    }

    public boolean hasAnyItem() {
        for (Inventory inv : this.pages) {
            for (ItemStack item : inv.getContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Inventory get(int page) {
        if (this.pages.size() >= page) {
            return this.pages.get(page - 1);
        }
        return null;
    }

    @Override
    public List<Inventory> getPages() {
        return this.pages;
    }

    @Override
    public Caller getShiftRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (shiftRightClickCallers.containsKey(inv) && (callers = (Map)shiftRightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }
}

