/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.Caller;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.InventoryLoadResult;
import pl.mirotcz.privatemessages.bukkit.inventories.Menu;
import pl.mirotcz.privatemessages.bukkit.items.ItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.sound.SoundConfiguration;
import pl.mirotcz.privatemessages.bukkit.sound.SoundConfigurationEntry;
import pl.mirotcz.privatemessages.bukkit.utils.InventoryEventUtils;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;
import pl.mirotcz.privatemessages.bukkit.utils.MaterialUtils;

public class SoundDetailsInventory
implements Menu {
    private List<Inventory> pages = new ArrayList<Inventory>();
    private List<Material> discs = new ArrayList<Material>();
    private Inventory parentMessagesView = null;
    private SoundConfiguration soundConfig;
    private PrivateMessages instance;

    public SoundDetailsInventory(PrivateMessages plugin, SoundConfiguration soundConfig, Inventory parentMessagesView) {
        this.instance = plugin;
        this.soundConfig = soundConfig;
        this.parentMessagesView = parentMessagesView;
        this.discs = MaterialUtils.getMusicDiscsMaterials();
    }

    private SoundConfiguration getSoundConfiguration() {
        return this.soundConfig;
    }

    private ItemStack getBackToSoundsItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().BACK_ITEM);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_BACK_ITEM_DISPLAYNAME);
        is.setItemMeta(itemMeta);
        return is;
    }

    private void addBackToSoundsItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        Caller left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
            PlayerStates.setState(player, PlayerStates.State.SWITCHING_INVENTORY);
            player.closeInventory();
            Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                PlayerStates.setState(player, PlayerStates.State.WAITING_SOUND_INVENTORY);
                player.openInventory(this.parentMessagesView);
            });
        });
        leftPageCallers.put(45, left);
        inv.setItem(45, this.getBackToSoundsItem());
    }

    @Override
    public InventoryLoadResult load() {
        Inventory inv = this.instance.getInventoryCreator().createInventory(null, 54, this.instance.getMessages().INV_SOUND_DETAILS_TITLE);
        this.pages = new ArrayList<Inventory>();
        List<SoundConfigurationEntry> soundEntries = this.getSoundConfiguration().getSounds();
        int count = 1;
        int allCount = 1;
        int pagesCount = 1;
        Iterator<SoundConfigurationEntry> it = soundEntries.iterator();
        HashMap<Integer, Caller> leftPageCallers = new HashMap<Integer, Caller>();
        HashMap<Integer, Caller> rightPageCallers = new HashMap<Integer, Caller>();
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemStack helpItem = new ItemStack(this.instance.getSettings().SOUND_DETAILS_HELP_ITEM_MATERIAL);
        ItemMeta helpItemMeta = helpItem.getItemMeta();
        helpItemMeta = itemMetaEditor.setDisplayName(helpItemMeta, this.instance.getMessages().INV_SOUND_DETAILS_HELP_ITEM_NAME);
        helpItemMeta = itemMetaEditor.setLore(helpItemMeta, this.instance.getMessages().INV_SOUND_DETAILS_HELP_ITEM_LORE);
        helpItem.setItemMeta(helpItemMeta);
        inv.setItem(49, helpItem);
        while (it.hasNext()) {
            Caller left;
            int finalPagesCount;
            ArrayList<String> pageItemLore;
            ItemMeta pageMeta;
            SoundConfigurationEntry soundConfigEntry = it.next();
            ItemStack item = new ItemStack(this.discs.get(MainUtils.getRandomInt(0, this.discs.size() - 1)));
            ItemMeta meta = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            if (!this.instance.getMessages().INV_SOUND_ITEM_LORE.isEmpty() && !this.instance.getMessages().INV_SOUND_ITEM_LORE.stream().anyMatch(line -> line.isEmpty())) {
                lore.addAll(this.instance.getMessages().INV_SOUND_ITEM_LORE);
            }
            ArrayList<String> finalLore = new ArrayList<String>(lore);
            for (int i = 0; i < finalLore.size(); ++i) {
                finalLore.set(i, ((String)finalLore.get(i)).replaceAll("<volume>", String.valueOf(soundConfigEntry.getVolume())).replaceAll("<pitch>", String.valueOf(soundConfigEntry.getPitch())).replaceAll("<soundName>", soundConfigEntry.getSoundInternalName()).replaceAll("<pause>", String.valueOf(soundConfigEntry.getPauseAfterInTicks())));
            }
            String displayName = this.instance.getMessages().INV_SOUND_ITEM_NAME.replaceAll("<soundName>", soundConfigEntry.getSoundInternalName()).replaceAll("<soundNumber>", String.valueOf(allCount));
            meta = itemMetaEditor.setDisplayName(meta, displayName);
            meta = itemMetaEditor.setLore(meta, finalLore);
            item.setItemMeta(meta);
            inv.setItem(count - 1, item);
            Caller rightClick = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> this.instance.getSoundPlayer().play(player, soundConfigEntry.getSoundInternalName(), soundConfigEntry.getVolume(), soundConfigEntry.getPitch()));
            rightPageCallers.put(count - 1, rightClick);
            if (!it.hasNext() || count == 45) {
                if (pagesCount > 1) {
                    ItemStack previousPageItem = new ItemStack(Material.ARROW);
                    pageMeta = previousPageItem.getItemMeta();
                    pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_PREVIOUS_PAGE);
                    pageItemLore = new ArrayList<String>();
                    pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount - 1)));
                    pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                    previousPageItem.setItemMeta(pageMeta);
                    finalPagesCount = pagesCount;
                    left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                        PlayerStates.setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                        player.openInventory(this.get(finalPagesCount - 1));
                        PlayerStates.setState(player, PlayerStates.State.WAITING_SOUND_DETAILS_INVENTORY);
                    });
                    leftPageCallers.put(52, left);
                    inv.setItem(52, previousPageItem);
                }
                inv.setItem(49, helpItem);
                this.addBackToSoundsItem(inv, leftPageCallers);
            }
            if (!it.hasNext()) {
                this.pages.add(inv);
                leftClickCallers.put(inv, leftPageCallers);
                rightClickCallers.put(inv, rightPageCallers);
                return InventoryLoadResult.SUCCESS;
            }
            if (count == 45) {
                ItemStack nextItem = new ItemStack(Material.ARROW);
                pageMeta = nextItem.getItemMeta();
                pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_NEXT_PAGE);
                pageItemLore = new ArrayList();
                pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount + 1)));
                pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                nextItem.setItemMeta(pageMeta);
                finalPagesCount = pagesCount++;
                left = player -> Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    PlayerStates.setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                    player.openInventory(this.get(finalPagesCount + 1));
                    PlayerStates.setState(player, PlayerStates.State.WAITING_SOUND_DETAILS_INVENTORY);
                });
                leftPageCallers.put(53, left);
                inv.setItem(53, nextItem);
                this.addBackToSoundsItem(inv, leftPageCallers);
                this.pages.add(inv);
                HashMap<Integer, Caller> finalLeftPageCallers = new HashMap<Integer, Caller>(leftPageCallers);
                HashMap finalRightPageCallers = new HashMap(rightPageCallers);
                leftClickCallers.put(inv, finalLeftPageCallers);
                rightClickCallers.put(inv, finalRightPageCallers);
                leftPageCallers = new HashMap();
                rightPageCallers = new HashMap();
                count = 1;
                inv = Bukkit.getServer().createInventory(null, 54, this.instance.getMessages().INV_SOUND_DETAILS_TITLE);
                continue;
            }
            ++count;
            ++allCount;
        }
        return InventoryLoadResult.SUCCESS;
    }

    public static boolean isValidInventory(InventoryClickEvent e) {
        if (InventoryEventUtils.getClickedInventory(e).getSize() != 54) {
            return false;
        }
        if (e.getView().getTitle() == null) {
            return false;
        }
        return e.getView().getTitle().equals(PrivateMessages.get().getMessages().INV_SOUND_DETAILS_TITLE);
    }

    public static boolean isValidInventory(Inventory inv, String title) {
        if (inv.getSize() != 54) {
            return false;
        }
        if (title == null) {
            return false;
        }
        return title.equals(PrivateMessages.get().getMessages().INV_SOUND_DETAILS_TITLE);
    }

    @Override
    public Caller getLeftClickCaller(Inventory inv, int slot) {
        Map callers;
        if (leftClickCallers.containsKey(inv) && (callers = (Map)leftClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (rightClickCallers.containsKey(inv) && (callers = (Map)rightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getShiftRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (shiftRightClickCallers.containsKey(inv) && (callers = (Map)shiftRightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Inventory get(int page) {
        if (this.pages.size() >= page) {
            return this.pages.get(page - 1);
        }
        return null;
    }

    @Override
    public List<Inventory> getPages() {
        return this.pages;
    }
}

