/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.listeners;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.inventories.Menu;
import pl.mirotcz.privatemessages.bukkit.inventories.MessageActionsInventory;
import pl.mirotcz.privatemessages.bukkit.inventories.MessagesInventory;
import pl.mirotcz.privatemessages.bukkit.inventories.SoundDetailsInventory;
import pl.mirotcz.privatemessages.bukkit.inventories.SoundInventory;
import pl.mirotcz.privatemessages.bukkit.utils.InventoryEventUtils;

public class InventoryClickListener
implements Listener {
    private PrivateMessages instance = null;

    public InventoryClickListener(PrivateMessages plugin) {
        this.instance = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle() == null) {
            return;
        }
        if (e.getView().getTitle().isEmpty()) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Inventory inv = InventoryEventUtils.getClickedInventory(e);
        if (inv == null) {
            return;
        }
        PlayerStates.State state = PlayerStates.getState(player);
        if (state != null && state != PlayerStates.State.IDLE) {
            e.setCancelled(true);
        }
        boolean valid_msg_inv = MessagesInventory.isValidInventory(e);
        boolean valid_msg_actions_inv = MessageActionsInventory.isValidInventory(e);
        boolean valid_sound_inv = SoundInventory.isValidInventory(e);
        boolean valid_sound_details_inv = SoundDetailsInventory.isValidInventory(e);
        if (!(valid_msg_inv || valid_msg_actions_inv || valid_sound_inv || valid_sound_details_inv)) {
            return;
        }
        e.setCancelled(true);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.instance, () -> {
            Menu processed_menu = null;
            PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManger().getData(player.getName());
            if (valid_msg_inv) {
                processed_menu = tempData.getLastMessagesInventory();
            } else if (valid_msg_actions_inv) {
                processed_menu = tempData.getLastMessageActionsInventory();
            } else if (valid_sound_inv) {
                processed_menu = tempData.getLastSoundInventory();
            } else if (valid_sound_details_inv) {
                processed_menu = tempData.getLastSoundDetailsInventory();
            }
            if (processed_menu == null) {
                Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    PlayerStates.setState(player, PlayerStates.State.IDLE);
                    player.closeInventory();
                });
            }
            if (e.getClick() == ClickType.LEFT) {
                if (processed_menu.getLeftClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getLeftClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
            if (e.getClick() == ClickType.RIGHT && !e.isShiftClick()) {
                if (processed_menu.getRightClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getRightClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
            if (e.getClick() == ClickType.SHIFT_RIGHT) {
                if (processed_menu.getShiftRightClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getShiftRightClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
        });
    }
}

