/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.listeners;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PlayerStates;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.inventories.MessageActionsInventory;
import pl.mirotcz.privatemessages.bukkit.inventories.MessagesInventory;
import pl.mirotcz.privatemessages.bukkit.inventories.SoundInventory;

public class InventoryCloseListener
implements Listener {
    private PrivateMessages instance;
    private List<Player> pluginInvokedInventoryOpenList = new ArrayList<Player>();

    public InventoryCloseListener(PrivateMessages plugin) {
        this.instance = plugin;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getPlayer() instanceof Player) {
            Player player = (Player)e.getPlayer();
            if (this.pluginInvokedInventoryOpenList.contains(player)) {
                return;
            }
            if (PlayerStates.getState(player) != null && PlayerStates.getState(player) != PlayerStates.State.SWITCHING_INVENTORY && PlayerStates.getState(player) != PlayerStates.State.CLOSING_GUI) {
                Inventory primary_inv = e.getInventory();
                boolean valid_msg_inv = MessagesInventory.isValidInventory(primary_inv, e.getView().getTitle());
                boolean valid_msg_actions_inv = MessageActionsInventory.isValidInventory(primary_inv, e.getView().getTitle());
                boolean valid_sound_inv = SoundInventory.isValidInventory(primary_inv, e.getView().getTitle());
                if (!(valid_msg_inv || valid_msg_actions_inv || valid_sound_inv)) {
                    PlayerStates.setState(player, PlayerStates.State.IDLE);
                    return;
                }
                this.pluginInvokedInventoryOpenList.add(player);
                Bukkit.getScheduler().runTask((Plugin)this.instance, () -> {
                    player.openInventory(primary_inv);
                    Bukkit.getScheduler().runTask((Plugin)this.instance, () -> this.pluginInvokedInventoryOpenList.remove(player));
                });
            }
        }
    }
}

