/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.integration.IVanishProvider;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_Essentials;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_PremiumVanish;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_SuperVanish;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_Vanish_NoPacket;

public class IntegrationsManager {
    private IVanishProvider vanish = null;
    private Integration_Essentials essentials = null;
    private PrivateMessages instance = null;
    private BukkitTask essentials_ignored_task = null;
    private static final String PREMIUMVANISH_PLUGIN = "PremiumVanish";
    private static final String SUPERVANISH_PLUGIN = "SuperVanish";
    private static final String VANISHNOPACKET_PLUGIN = "VanishNoPacket";
    private static final String ESSENTIALS_PLUGIN = "Essentials";
    private String used_vanish_plugin_name = null;

    public IntegrationsManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void setupIntegrations() {
        if (this.instance.getServer().getPluginManager().getPlugin(PREMIUMVANISH_PLUGIN) != null) {
            try {
                this.vanish = new Integration_PremiumVanish();
                this.used_vanish_plugin_name = PREMIUMVANISH_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(PREMIUMVANISH_PLUGIN);
            }
        }
        if (this.vanish == null && this.instance.getServer().getPluginManager().getPlugin(SUPERVANISH_PLUGIN) != null) {
            try {
                this.vanish = new Integration_SuperVanish();
                this.used_vanish_plugin_name = SUPERVANISH_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(SUPERVANISH_PLUGIN);
            }
        }
        if (this.vanish == null && this.instance.getServer().getPluginManager().getPlugin(VANISHNOPACKET_PLUGIN) != null) {
            try {
                this.vanish = new Integration_Vanish_NoPacket();
                this.used_vanish_plugin_name = VANISHNOPACKET_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(VANISHNOPACKET_PLUGIN);
            }
        }
        if (this.instance.getServer().getPluginManager().getPlugin(ESSENTIALS_PLUGIN) != null) {
            try {
                this.essentials = new Integration_Essentials();
                this.sendEssentialsExtendedIntegrationEnabledMessage();
                if (this.vanish == null) {
                    this.vanish = this.essentials;
                    this.used_vanish_plugin_name = ESSENTIALS_PLUGIN;
                }
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(ESSENTIALS_PLUGIN);
            }
        }
    }

    public IVanishProvider getVanish() {
        return this.vanish;
    }

    public boolean isVanishSupported() {
        return this.vanish != null;
    }

    public String getUsedVanishPluginName() {
        return this.used_vanish_plugin_name;
    }

    public boolean isEssentialsPresent() {
        return this.essentials != null;
    }

    public boolean isIgnoredOnSupportedIntegration(String ignored, String ignoring) {
        if (this.isEssentialsPresent()) {
            return this.essentials.isIgnored(ignored, ignoring);
        }
        return false;
    }

    public List<String> getIgnoredOnEssentials(String ignoring) {
        Map<String, List<String>> all_ignores;
        if (this.isEssentialsPresent() && (all_ignores = this.essentials.getAllIgnores()).containsKey(ignoring)) {
            return all_ignores.get(ignoring);
        }
        return new ArrayList<String>();
    }

    private void sendEssentialsExtendedIntegrationEnabledMessage() {
        this.instance.getLogger().info("Enabled extended Essentials integration.");
    }

    private void sendVanishHookErrorMessages(String pluginName) {
        this.instance.getLogger().warning("PrivateMessages tried to hook into " + pluginName + " plugin but it looks like it hasn't loaded properly.");
        this.instance.getLogger().warning("Check for error messages related to " + pluginName + " plugin and fix all found issues.");
        this.instance.getLogger().warning("PrivateMessages will continue working and try to hook into other present vanish plugins.");
    }

    public void startEssentialsIgnoreDataToStorageTask() {
        this.essentials_ignored_task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, () -> this.sendEssentialsIgnoreDataToStorage(), 200L, 200L);
    }

    public void stopEssentialsIgnoreDataToStorageTask() {
        if (this.essentials_ignored_task != null && Bukkit.getScheduler().isCurrentlyRunning(this.essentials_ignored_task.getTaskId())) {
            this.essentials_ignored_task.cancel();
        }
    }

    private void sendEssentialsIgnoreDataToStorage() {
        this.instance.getStorage().sendEssentialsIgnoreData(this.essentials.getAllIgnores());
    }
}

