/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.integration.IVanishProvider;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_Essentials;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_PremiumVanish;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_SuperVanish;
import pl.mirotcz.privatemessages.bukkit.integration.Integration_Vanish_NoPacket;
import pl.mirotcz.privatemessages.bukkit.listeners.CommandListener;
import pl.mirotcz.privatemessages.bukkit.listeners.EssentialsVanishListener;
import pl.mirotcz.privatemessages.bukkit.listeners.InventoryClickListener;
import pl.mirotcz.privatemessages.bukkit.listeners.InventoryCloseListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PlayerJoinListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PlayerQuitListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PlayerSettingsModifyListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PluginMessagesListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PremiumVanishListener;
import pl.mirotcz.privatemessages.bukkit.listeners.PrivateMessageListener;
import pl.mirotcz.privatemessages.bukkit.listeners.VanishNoPacketListener;

public class ListenersManager {
    private PrivateMessages instance;
    private CommandListener commandListener;
    private PlayerJoinListener playerJoinListener;
    private PlayerQuitListener playerQuitListener;
    private InventoryClickListener inventoryClickListener;
    private InventoryCloseListener inventoryCloseListener;
    private PlayerSettingsModifyListener playerSettingsModifyListener;
    private PrivateMessageListener privateMessageListener;
    private PluginMessagesListener pluginMessagesListener;
    private PremiumVanishListener premiumVanishListener;
    private VanishNoPacketListener vanishNoPacketListener;
    private EssentialsVanishListener essVanishListener;

    public ListenersManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public CommandListener getCommandListener() {
        return this.commandListener;
    }

    public PlayerJoinListener getPlayerJoinListener() {
        return this.playerJoinListener;
    }

    public PlayerQuitListener getPlayerQuitListener() {
        return this.playerQuitListener;
    }

    public InventoryClickListener getInventoryClickListener() {
        return this.inventoryClickListener;
    }

    public InventoryCloseListener getInventoryCloseListener() {
        return this.inventoryCloseListener;
    }

    public PlayerSettingsModifyListener getPlayerSettingsModifyListener() {
        return this.playerSettingsModifyListener;
    }

    public PrivateMessageListener getPrivateMessageListener() {
        return this.privateMessageListener;
    }

    public PluginMessagesListener getPluginMessagesListener() {
        return this.pluginMessagesListener;
    }

    public PremiumVanishListener getPremiumVanishListener() {
        return this.premiumVanishListener;
    }

    public VanishNoPacketListener getVanishNoPacketListener() {
        return this.vanishNoPacketListener;
    }

    public EssentialsVanishListener getEssentialsVanishListener() {
        return this.essVanishListener;
    }

    public void setupListeners() {
        this.commandListener = new CommandListener(this.instance);
        this.commandListener.registerCommands();
        this.commandListener.registerTabCompleters();
        this.playerJoinListener = new PlayerJoinListener(this.instance);
        this.playerQuitListener = new PlayerQuitListener(this.instance);
        this.inventoryClickListener = new InventoryClickListener(this.instance);
        this.inventoryCloseListener = new InventoryCloseListener(this.instance);
        this.playerSettingsModifyListener = new PlayerSettingsModifyListener(this.instance);
        this.privateMessageListener = new PrivateMessageListener(this.instance);
        this.pluginMessagesListener = new PluginMessagesListener(this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerJoinListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerQuitListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryClickListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryCloseListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerSettingsModifyListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.privateMessageListener, (Plugin)this.instance);
        if (this.instance.getSettings().PROXY) {
            this.pluginMessagesListener.load();
        }
        if (this.instance.getManagers().getIntegrationManager().isVanishSupported()) {
            IVanishProvider vanish = this.instance.getVanish();
            if (vanish instanceof Integration_PremiumVanish || vanish instanceof Integration_SuperVanish) {
                this.premiumVanishListener = new PremiumVanishListener(this.instance);
                Bukkit.getPluginManager().registerEvents((Listener)this.premiumVanishListener, (Plugin)this.instance);
            } else if (vanish instanceof Integration_Vanish_NoPacket) {
                this.vanishNoPacketListener = new VanishNoPacketListener(this.instance);
                Bukkit.getPluginManager().registerEvents((Listener)this.vanishNoPacketListener, (Plugin)this.instance);
            } else if (vanish instanceof Integration_Essentials) {
                try {
                    Class.forName("net.ess3.api.events.VanishStatusChangeEvent");
                    this.essVanishListener = new EssentialsVanishListener(this.instance);
                    Bukkit.getPluginManager().registerEvents((Listener)this.essVanishListener, (Plugin)this.instance);
                }
                catch (ClassNotFoundException e) {
                    this.instance.getLogger().info("This server is running very old version of Essentials plugin. PrivateMessages won't be able to react to player vanish status change due to lack of required api class.");
                }
            }
        }
    }
}

