/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.managers.FileConfigManagers;
import pl.mirotcz.privatemessages.bukkit.managers.IntegrationsManager;
import pl.mirotcz.privatemessages.bukkit.managers.ListenersManager;
import pl.mirotcz.privatemessages.bukkit.managers.MenuManager;
import pl.mirotcz.privatemessages.bukkit.managers.MessagesManager;
import pl.mirotcz.privatemessages.bukkit.managers.PendingMessagesManager;
import pl.mirotcz.privatemessages.bukkit.managers.PlayerSettingsManager;
import pl.mirotcz.privatemessages.bukkit.managers.PlayerTempDataManager;
import pl.mirotcz.privatemessages.bukkit.managers.SettingsManager;
import pl.mirotcz.privatemessages.bukkit.managers.SoundConfigurationsManager;
import pl.mirotcz.privatemessages.bukkit.managers.StorageManager;

public class Managers {
    private FileConfigManagers configManagers;
    private SoundConfigurationsManager soundConfigurationsManager;
    private PlayerSettingsManager playerSettingsManager;
    private ListenersManager listenersManager;
    private StorageManager storageManager;
    private SettingsManager settingsManager;
    private MessagesManager messagesManager;
    private IntegrationsManager integrationManager;
    private MenuManager menuManager;
    private PendingMessagesManager pendingMessagesManager;
    private PlayerTempDataManager playerTempDataManager;
    private PrivateMessages instance;

    public Managers(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void load() {
        this.configManagers = new FileConfigManagers();
        this.configManagers.setupConfigs();
        this.configManagers.reloadConfigs();
        this.messagesManager = new MessagesManager();
        this.messagesManager.load();
        this.settingsManager = new SettingsManager();
        this.settingsManager.load();
        this.storageManager = new StorageManager(this.instance);
        this.storageManager.setupStorage();
        this.soundConfigurationsManager = new SoundConfigurationsManager(this.instance);
        this.soundConfigurationsManager.load();
        this.playerSettingsManager = new PlayerSettingsManager(this.instance);
        this.playerSettingsManager.loadAllFromStorage();
        this.playerSettingsManager.registerSaveTask();
        this.integrationManager = new IntegrationsManager(this.instance);
        this.integrationManager.setupIntegrations();
        if (this.integrationManager.isEssentialsPresent() && this.getSettingsManager().ESSENTIALS_IGNORE_RESPECT && this.getSettingsManager().PROXY) {
            this.integrationManager.startEssentialsIgnoreDataToStorageTask();
        }
        this.listenersManager = new ListenersManager(this.instance);
        this.listenersManager.setupListeners();
        this.pendingMessagesManager = new PendingMessagesManager(this.instance);
        this.pendingMessagesManager.startSaveTask();
        this.playerTempDataManager = new PlayerTempDataManager();
    }

    public FileConfigManagers getConfigManagers() {
        return this.configManagers;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public SoundConfigurationsManager getSoundConfigurationsManager() {
        return this.soundConfigurationsManager;
    }

    public IntegrationsManager getIntegrationManager() {
        return this.integrationManager;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public PendingMessagesManager getPendingMessagesManager() {
        return this.pendingMessagesManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public PlayerTempDataManager getPlayerTempDataManger() {
        return this.playerTempDataManager;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public void setupMenuManager() {
    }
}

