/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;

public class PendingMessagesManager {
    private List<Message> pending_messages = new ArrayList<Message>();
    private List<Message> pending_unread_messages = new ArrayList<Message>();
    private PrivateMessages instance = null;
    private BukkitTask task = null;

    public PendingMessagesManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public List<Message> getPendingMessages() {
        return this.pending_messages;
    }

    public List<Message> getPendingUnreadMessages() {
        return this.pending_unread_messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            if (!this.pending_messages.contains(message)) {
                this.pending_messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingUnreadMessage(Message message) {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            if (!this.pending_unread_messages.contains(message)) {
                this.pending_unread_messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.remove(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingUnreadMessage(Message message) {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            if (this.pending_unread_messages.contains(message)) {
                this.pending_unread_messages.remove(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingMessagesToStorage() {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.forEach(message -> this.instance.getStorage().saveMessage((Message)message));
            this.pending_messages = new ArrayList<Message>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingUnreadMessagesToStorage() {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            this.pending_unread_messages.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            this.pending_unread_messages = new ArrayList<Message>();
        }
    }

    public void startSaveTask() {
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, () -> {
            this.savePendingMessagesToStorage();
            this.savePendingUnreadMessagesToStorage();
        }, (long)(this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS * 20), (long)(this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS * 20));
    }

    public void cancelSaveTask() {
        if (Bukkit.getScheduler().isCurrentlyRunning(this.task.getTaskId())) {
            Bukkit.getScheduler().cancelTask(this.task.getTaskId());
        }
    }
}

