/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;

public class PlayerSettingsManager {
    private Map<String, PlayerSettings> playerSettings = new HashMap<String, PlayerSettings>();
    private volatile BlockingQueue<PlayerSettings> pendingChanges = new ArrayBlockingQueue<PlayerSettings>(256);
    private BukkitTask registeredTask = null;
    private PrivateMessages instance;

    public PlayerSettingsManager(PrivateMessages plugin) {
        this.playerSettings = new HashMap<String, PlayerSettings>();
        this.instance = plugin;
    }

    public void loadAllFromStorage() {
        this.playerSettings = this.instance.getStorage().loadAllPlayerSettings();
    }

    public void loadFromStorage(String player_name) {
        PlayerSettings settings = this.instance.getStorage().getPlayerSettings(player_name);
        this.playerSettings.put(player_name, settings);
    }

    public PlayerSettings getPlayerSettings(String playerName) {
        if (this.playerSettings.containsKey(playerName)) {
            return this.playerSettings.get(playerName);
        }
        if (!this.instance.getSettings().PROXY) {
            this.createNewSettings(playerName);
            PlayerSettings settings = this.playerSettings.get(playerName);
            return settings;
        }
        return null;
    }

    public void addPendingChanges(String playerName) {
        if (!this.pendingChanges.contains(this.getPlayerSettings(playerName))) {
            this.pendingChanges.add(this.getPlayerSettings(playerName));
        }
    }

    public void addPendingChanges(PlayerSettings data) {
        if (!this.pendingChanges.contains(data)) {
            this.pendingChanges.add(data);
        }
    }

    public Map<String, PlayerSettings> getAllSettings() {
        return this.playerSettings;
    }

    public synchronized void addPlayerSettings(String playerName, PlayerSettings settings) {
        this.playerSettings.put(playerName, settings);
    }

    public synchronized void createNewSettings(String player_name) {
        PlayerSettings settings = new PlayerSettings();
        settings.setPlayerName(player_name);
        this.playerSettings.put(player_name, settings);
        this.pendingChanges.add(settings);
    }

    public synchronized void removePlayerData(PlayerSettings settings) {
        Iterator<Map.Entry<String, PlayerSettings>> it = this.playerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PlayerSettings> entry = it.next();
            if (entry.getValue() != settings) continue;
            it.remove();
            return;
        }
    }

    public synchronized void removePlayerData(String name) {
        Iterator<Map.Entry<String, PlayerSettings>> it = this.playerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PlayerSettings> entry = it.next();
            if (!entry.getValue().getPlayerName().equalsIgnoreCase(name)) continue;
            it.remove();
            return;
        }
    }

    public void savePendingChanges() {
        ArrayBlockingQueue<PlayerSettings> queue = new ArrayBlockingQueue<PlayerSettings>(256);
        queue.addAll(this.pendingChanges);
        ArrayList<String> already_saved = new ArrayList<String>();
        for (PlayerSettings data : queue) {
            if (already_saved.stream().anyMatch(x -> x.equalsIgnoreCase(data.getPlayerName()))) continue;
            PrivateMessages.get().getManagers().getStorageManager().getStorage().savePlayerSettings(data);
            already_saved.add(data.getPlayerName());
        }
        queue.clear();
        this.pendingChanges.clear();
    }

    public void registerSaveTask() {
        this.registeredTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)PrivateMessages.get(), () -> this.savePendingChanges(), 100L, 100L);
    }

    public void cancelSaveTask() {
        if (this.registeredTask != null) {
            this.registeredTask.cancel();
        }
    }

    public void reloadSettings(String player_name) {
        if (player_name == null) {
            return;
        }
        PlayerSettings settings = this.getPlayerSettings(player_name);
        if (settings == null) {
            return;
        }
        PlayerSettings updated_settings = PrivateMessages.get().getStorage().getPlayerSettings(player_name);
        if (updated_settings != null) {
            Long id = updated_settings.getId();
            String name = updated_settings.getPlayerName();
            int sound_number = updated_settings.getMessageNotificationSoundNumber();
            boolean sound_enabled = updated_settings.isMessageNotificationSoundEnabled();
            boolean spy_enabled = updated_settings.isMessageSpyEnabled();
            Set<String> ignored_players = updated_settings.getIgnoredPlayers();
            boolean msg_enabled = updated_settings.arePrivateMessagesEnabled();
            boolean tips_enabled = updated_settings.arePluginTipsEnabled();
            int unread_messages_tips_count = updated_settings.getUnreadMessagesTipsCount();
            int notification_sound_tips_count = updated_settings.getNotificationSoundTipsCount();
            Bukkit.getScheduler().runTask((Plugin)this.instance, () -> settings.load(id, name, sound_number, sound_enabled, spy_enabled, ignored_players, msg_enabled, tips_enabled, unread_messages_tips_count, notification_sound_tips_count));
        }
    }

    public boolean playerSettingsExists(String playerName) {
        return this.playerSettings.containsKey(playerName);
    }
}

