/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.managers;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.managers.FileConfigManager;

public class SettingsManager {
    public String STORAGE_TYPE;
    public String DB_HOST;
    public String DB_NAME;
    public String DB_USER;
    public String DB_PASS;
    public int DB_PORT;
    public DateTimeFormatter MESSAGES_HISTORY_DATETIME_FORMATTER;
    public List<DateTimeFormatter> IN_COMMAND_DATETIME_FORMATTERS;
    public List<String> IN_COMMAND_DATETIME_FORMAT_PLAIN;
    public String TIME_ZONE;
    public int MESSAGE_SAVE_INTERVAL_SECONDS = 10;
    public int MAX_HISTORY_MESSAGES_PER_SECOND = 5000;
    public boolean EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION = false;
    public boolean DISPLAY_INACCESSIBLE_SOUNDS_IN_SOUND_INVENTORY = true;
    public boolean MESSAGES_HISTORY_ENABLED = true;
    public boolean ALLOW_SENDING_MESSAGES_TO_SELF = true;
    public boolean ALLOW_REPLYING_TO_CONSOLE = true;
    public boolean ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS = true;
    public boolean SPY_IN_CONSOLE = false;
    public Material SOUND_HELP_ITEM_MATERIAL = Material.PAPER;
    public Material SOUND_DETAILS_HELP_ITEM_MATERIAL = Material.PAPER;
    public Material SOUND_TOGGLE_ITEM_MATERIAL = Material.LEVER;
    public Material MESSAGE_ITEM_1_MATERIAL = PrivateMessages.isMinecraftVersionAtLeast("1.12") ? Material.valueOf((String)"LIME_TERRACOTTA") : Material.valueOf((String)"GRASS");
    public Material MESSAGE_ITEM_2_MATERIAL = PrivateMessages.isMinecraftVersionAtLeast("1.12") ? Material.valueOf((String)"RED_TERRACOTTA") : Material.valueOf((String)"DIRT");
    public int GLOBAL_HISTORY_CACHE_TIME_SECONDS = 600;
    public boolean PROXY = false;
    public boolean METRICS = true;
    public boolean NOTIFY_UNREAD_MESSAGES_AFTER_JOIN = true;
    public boolean NOTIFY_UNREAD_MESSAGES_AFTER_UNVANISH = true;
    public boolean MINIMESSAGE_CHAT_FORMATTING = false;
    public boolean PLUGIN_TIPS = true;
    public int PLUGIN_TIPS_MODE = 1;
    public boolean ESSENTIALS_IGNORE_RESPECT = true;
    public boolean MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = true;
    public boolean MESSAGES_DELETION_BY_INVENTORY_REQUIRES_CONFIRMATION = true;
    public Material BACK_ITEM = Material.REDSTONE_BLOCK;
    public Material EXIT_ITEM = Material.REDSTONE_BLOCK;
    public Material MESSAGE_ACTION_DELETE_ITEM_MATERIAL = Material.LAVA_BUCKET;

    public void load() {
        FileConfigManager config = PrivateMessages.get().getManagers().getConfigManagers().getMainConfigManager();
        this.STORAGE_TYPE = config.getConfig().getString("Storage.type");
        this.DB_HOST = config.getConfig().getString("Storage.hostname");
        this.DB_NAME = config.getConfig().getString("Storage.database");
        this.DB_USER = config.getConfig().getString("Storage.user");
        this.DB_PASS = config.getConfig().getString("Storage.password");
        this.DB_PORT = config.getConfig().getInt("Storage.port");
        this.TIME_ZONE = config.getConfig().contains("MessagesHistory.TimeZone") ? config.getConfig().getString("MessagesHistory.TimeZone") : config.getConfig().getString("TimeZone");
        try {
            ZoneId.of(this.TIME_ZONE);
        }
        catch (DateTimeException ex) {
            PrivateMessages.get().getLogger().warning("Invalid time zone: " + this.TIME_ZONE + ". Using default zone (Europe/Warsaw).");
            this.TIME_ZONE = "Europe/Warsaw";
        }
        this.IN_COMMAND_DATETIME_FORMAT_PLAIN = config.getConfig().getStringList("InCommandDateTimeFormat");
        this.IN_COMMAND_DATETIME_FORMATTERS = new ArrayList<DateTimeFormatter>();
        for (String formatPlain : this.IN_COMMAND_DATETIME_FORMAT_PLAIN) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(formatPlain).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
            this.IN_COMMAND_DATETIME_FORMATTERS.add(formatter);
        }
        this.MESSAGES_HISTORY_ENABLED = config.getConfig().getBoolean("MessagesHistory.Enabled");
        this.MESSAGES_HISTORY_DATETIME_FORMATTER = DateTimeFormatter.ofPattern(config.getConfig().getString("MessagesHistory.DateFormat")).withZone(ZoneId.of(this.TIME_ZONE));
        this.ALLOW_SENDING_MESSAGES_TO_SELF = config.getConfig().getBoolean("AllowSendingMessagesToSelf");
        this.ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS = config.getConfig().getBoolean("AllowSendingMessagesToOfflinePlayers");
        this.SOUND_HELP_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundHelpItem"));
        this.SOUND_DETAILS_HELP_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundDetailsHelpItem"));
        this.SOUND_TOGGLE_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundToggleItem"));
        this.MESSAGE_ACTION_DELETE_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("MessageActionDeleteItem"));
        this.SPY_IN_CONSOLE = config.getConfig().getBoolean("SpyInConsole");
        this.MESSAGE_SAVE_INTERVAL_SECONDS = config.getConfig().getInt("MessagesSaveIntervalSeconds");
        this.MAX_HISTORY_MESSAGES_PER_SECOND = config.getConfig().getInt("MaxHistoryMessagesPerSecond");
        this.GLOBAL_HISTORY_CACHE_TIME_SECONDS = config.getConfig().getInt("GlobalHistoryCacheTimeSeconds");
        this.PROXY = config.getConfig().contains("BungeeCord") ? config.getConfig().getBoolean("BungeeCord") : config.getConfig().getBoolean("Proxy");
        this.METRICS = config.getConfig().getBoolean("Metrics");
        this.NOTIFY_UNREAD_MESSAGES_AFTER_JOIN = config.getConfig().getBoolean("NotifyUnreadMessagesAfterJoin");
        this.NOTIFY_UNREAD_MESSAGES_AFTER_UNVANISH = config.getConfig().getBoolean("NotifyUnreadMessagesAfterUnvanish");
        this.MINIMESSAGE_CHAT_FORMATTING = config.getConfig().getBoolean("MiniMessageChatFormatting");
        this.PLUGIN_TIPS = config.getConfig().getBoolean("PluginTips.Enabled");
        this.PLUGIN_TIPS_MODE = config.getConfig().getInt("PluginTips.Mode");
        this.PLUGIN_TIPS_MODE = this.PLUGIN_TIPS_MODE >= 1 && this.PLUGIN_TIPS_MODE <= 2 ? this.PLUGIN_TIPS_MODE : 1;
        this.ESSENTIALS_IGNORE_RESPECT = config.getConfig().getBoolean("Integration.Essentials.RespectIgnore");
        this.MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = config.getConfig().getBoolean("MessagesDeletionByCommandRequiresConfirmation");
        this.MESSAGES_DELETION_BY_INVENTORY_REQUIRES_CONFIRMATION = config.getConfig().getBoolean("MessagesDeletionByInventoryRequiresConfirmation");
        this.BACK_ITEM = Material.valueOf((String)config.getConfig().getString("BackItem"));
        this.EXIT_ITEM = Material.valueOf((String)config.getConfig().getString("ExitItem"));
        this.EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION = config.getConfig().getBoolean("EachNotificationSoundRequiresPermission");
        this.DISPLAY_INACCESSIBLE_SOUNDS_IN_SOUND_INVENTORY = config.getConfig().getBoolean("DisplayInaccessibleSoundsInSoundInventory");
        Material messageItem1 = null;
        Material messageItem2 = null;
        try {
            messageItem1 = Material.valueOf((String)config.getConfig().getString("MessageItem1"));
            messageItem2 = Material.valueOf((String)config.getConfig().getString("MessageItem2"));
            this.MESSAGE_ITEM_1_MATERIAL = messageItem1;
            this.MESSAGE_ITEM_2_MATERIAL = messageItem2;
        }
        catch (IllegalArgumentException e) {
            if (!PrivateMessages.isMinecraftVersionAtLeast("1.13")) {
                config.getConfig().set("MessageItem1", (Object)this.MESSAGE_ITEM_1_MATERIAL.toString());
                config.getConfig().set("MessageItem2", (Object)this.MESSAGE_ITEM_2_MATERIAL.toString());
                config.saveConfig();
                config.reloadConfig();
                PrivateMessages.get().getLogger().info("Using pre-1.13 default materials for message items.");
            }
            e.printStackTrace();
        }
    }

    public void save() {
        FileConfigManager config = PrivateMessages.get().getManagers().getConfigManagers().getMainConfigManager();
        config.getConfig().set("SpyInConsole", (Object)this.SPY_IN_CONSOLE);
        config.saveConfig();
        config.reloadConfig();
    }
}

