/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.sound;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.sound.SoundConfiguration;
import pl.mirotcz.privatemessages.bukkit.sound.SoundConfigurationEntry;

public class SoundPlayer {
    private PrivateMessages instance;

    public SoundPlayer(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void play(Player player, String name, float volume, float pitch) {
        player.playSound(player.getLocation(), Sound.valueOf((String)name), volume, pitch);
    }

    private void play(Player player, List<SoundConfigurationEntry> sounds) {
        long accumulatedDelay = 0L;
        for (SoundConfigurationEntry soundEntry : sounds) {
            if (accumulatedDelay > 0L) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> this.play(player, soundEntry.getSoundInternalName(), soundEntry.getVolume(), soundEntry.getPitch()), accumulatedDelay);
            } else {
                this.play(player, soundEntry.getSoundInternalName(), soundEntry.getVolume(), soundEntry.getPitch());
            }
            if (soundEntry.getPauseAfterInTicks() <= 0L) continue;
            accumulatedDelay += soundEntry.getPauseAfterInTicks();
        }
    }

    public void play(Player player, SoundConfiguration soundConfig) {
        this.play(player, soundConfig.getSounds());
    }
}

