/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.DateRelationType;
import pl.mirotcz.privatemessages.bukkit.data.PlayerSettings;
import pl.mirotcz.privatemessages.bukkit.storage.Storage;
import pl.mirotcz.privatemessages.bukkit.storage.data.SchemaRetrievalResult;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;
import pl.mirotcz.privatemessages.bukkit.utils.StringUtils;

public class Storage_MySQL
implements Storage {
    private PrivateMessages instance;
    private HikariConfig config;
    private HikariDataSource ds;
    private final int latest_schema_version = 1;
    volatile Connection conn;
    private String unread_messages_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_unread_messages (\n\tID INT PRIMARY KEY AUTO_INCREMENT,\n\tSENDER VARCHAR(16) NOT NULL,\n\tRECIPIENT VARCHAR(16) NOT NULL,\n\tMESSAGE VARCHAR(256) NOT NULL,\n DATE BIGINT(20) NOT NULL\n);";
    private String player_settings_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_player_settings (\n\tID INT PRIMARY KEY AUTO_INCREMENT,\n\tPLAYER_NAME VARCHAR(16) NOT NULL,\n\tSOUND_ENABLED INT(1) DEFAULT 1,\n\tSOUND_NUMBER INT(3) DEFAULT 1, \n IGNORED_PLAYERS TEXT, \n SPY_ENABLED INT(1), \n PRIVATE_MESSAGES_ENABLED INT(1) DEFAULT 1,\n PLUGIN_TIPS_ENABLED INT(1) DEFAULT 1,\n NOTIFICATION_SOUND_TIPS_COUNT INT(1) DEFAULT 0,\n UNREAD_MESSAGES_TIPS_COUNT INT(1) DEFAULT 0\n);";
    private String messages_history_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_messages_history (\n\tID INT PRIMARY KEY AUTO_INCREMENT,\n\tSENDER VARCHAR(16) NOT NULL,\n\tRECIPIENT VARCHAR(16) NOT NULL,\n\tMESSAGE VARCHAR(256) NOT NULL,\n\tDATE BIGINT(20) NOT NULL\n);";
    private String players_waiting_settings_reload_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_players_waiting_settings_reload (\n\tID INT PRIMARY KEY AUTO_INCREMENT,\n\tPLAYER_NAME VARCHAR(16) NOT NULL,\n\tDATE BIGINT(20) NOT NULL\n);";
    private String vanished_players_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_vanished_players (\n\tPLAYER_NAME VARCHAR(16) NOT NULL,\n\tDATE BIGINT(20) NOT NULL\n);";
    private String integrations_data_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_integrations_data (\n\tID INT PRIMARY KEY AUTO_INCREMENT,\n\tESSENTIALS_IGNORES TEXT\n);";
    private String schema_table_creation_query = "CREATE TABLE IF NOT EXISTS pmsg_schema_version (\n\tSCHEMA_VERSION INT(6) DEFAULT 1\n);";
    private String dbaddress;
    private String dbname;
    private String dbuser;
    private String dbpass;
    private int dbport;

    public Storage_MySQL(PrivateMessages plugin) {
        this.instance = plugin;
        this.dbaddress = this.instance.getSettings().DB_HOST;
        this.dbname = this.instance.getSettings().DB_NAME;
        this.dbuser = this.instance.getSettings().DB_USER;
        this.dbpass = this.instance.getSettings().DB_PASS;
        this.dbport = this.instance.getSettings().DB_PORT;
        this.config = new HikariConfig();
        this.config.setJdbcUrl("jdbc:mysql://" + this.dbaddress + ":" + this.dbport + "/" + this.dbname + "?allowPublicKeyRetrieval=true&useSSL=false");
        this.config.setUsername(this.dbuser);
        this.config.setPassword(this.dbpass);
        this.config.addDataSourceProperty("cachePrepStmts", "true");
        this.config.addDataSourceProperty("prepStmtCacheSize", "250");
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.config.addDataSourceProperty("useServerPrepStmts", true);
        this.config.addDataSourceProperty("characterEncoding", "utf8");
        this.config.addDataSourceProperty("useUnicode", true);
        this.config.setLeakDetectionThreshold(10000L);
        this.config.setMaximumPoolSize(3);
        this.ds = new HikariDataSource(this.config);
        this.setupTables();
    }

    private String getSchemaTableInsertQueryForVersion(int value) {
        return "INSERT INTO pmsg_schema_version (SCHEMA_VERSION) VALUES (" + value + ");";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaTable(int version) {
        String delete_query = "DELETE FROM pmsg_schema_version";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(delete_query);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.getSchemaTableInsertQueryForVersion(version));
            ps.execute();
            ps.close();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTables() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            SchemaRetrievalResult schema = this.getStoredSchema();
            if (!schema.isPresent()) {
                ps = conn.prepareStatement(this.schema_table_creation_query);
                ps.executeUpdate();
                ps.close();
                if (this.tableExists("pmsg_player_settings") && this.tableExists("pmsg_unread_messages") && this.tableExists("pmsg_messages_history") && this.tableExists("pmsg_vanished_players") && this.tableExists("pmsg_players_waiting_settings_reload")) {
                    this.updateSchemaTable(1);
                    this.updateTablesPre1();
                } else {
                    this.updateSchemaTable(1);
                }
            } else {
                this.updateOldTablesIfNeeded(schema);
            }
            ps = conn.prepareStatement(this.unread_messages_table_creation_query);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.player_settings_table_creation_query);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.messages_history_table_creation_query);
            ps.executeUpdate();
            ps.close();
            if (this.instance.getSettings().PROXY) {
                ps = conn.prepareStatement(this.players_waiting_settings_reload_table_creation_query);
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.vanished_players_table_creation_query);
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.integrations_data_table_creation_query);
                ps.executeUpdate();
                ps.close();
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(conn, ps, null);
        }
    }

    @Override
    public void close(Connection conn, PreparedStatement ps, ResultSet res) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (res != null) {
            try {
                res.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closePool() {
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(String table_name) {
        boolean table_exists = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '" + this.dbname + "' AND table_name = '" + table_name + "'";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            table_exists = rs.isBeforeFirst() && rs.next() && rs.getInt(1) > 0;
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return table_exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaRetrievalResult getStoredSchema() {
        SchemaRetrievalResult schema = new SchemaRetrievalResult();
        int stored_schema_version = 0;
        if (!this.tableExists("pmsg_schema_version")) {
            schema.setVersion(stored_schema_version);
            return schema;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_schema_version";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                stored_schema_version = rs.getInt("SCHEMA_VERSION");
                schema.setIsPresent(true);
                schema.setVersion(stored_schema_version);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTablesPre1() {
        String player_settings_add_tips_column_query = "ALTER TABLE pmsg_player_settings ADD PLUGIN_TIPS_ENABLED INT(1) DEFAULT 1";
        String player_settings_add_notification_tips_count_query = "ALTER TABLE pmsg_player_settings ADD NOTIFICATION_SOUND_TIPS_COUNT INT(1) DEFAULT 0";
        String player_settings_add_unread_tips_count_query = "ALTER TABLE pmsg_player_settings ADD UNREAD_MESSAGES_TIPS_COUNT INT(1) DEFAULT 0";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(player_settings_add_tips_column_query);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(player_settings_add_notification_tips_count_query);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(player_settings_add_unread_tips_count_query);
            ps.execute();
            ps.close();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOldTablesIfNeeded(SchemaRetrievalResult schema) {
        int existing_schema_version = schema.getVersion();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_schema_version";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                existing_schema_version = rs.getInt("SCHEMA_VERSION");
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        if (existing_schema_version < 1) {
            this.updateTablesPre1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendVanishedPlayerInfo(String player_name) {
        long time = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "INSERT INTO pmsg_vanished_players (PLAYER_NAME, DATE) VALUES (?, ?)";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player_name);
            ps.setLong(2, time);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUnreadMessage(Message message) {
        boolean contains_id;
        Connection conn = null;
        PreparedStatement ps = null;
        boolean update = this.unreadMessageExists(message.getId());
        boolean bl = contains_id = message.getId() != -1L;
        String query = update ? "UPDATE pmsg_unread_messages SET SENDER = ?, RECIPIENT = ?, MESSAGE = ?, DATE = ? WHERE ID = ?" : (contains_id ? "INSERT INTO pmsg_unread_messages (SENDER, RECIPIENT, MESSAGE, DATE, ID) VALUES (?, ?, ?, ?, ?)" : "INSERT INTO pmsg_unread_messages (SENDER, RECIPIENT, MESSAGE, DATE) VALUES (?, ?, ?, ?)");
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, message.getSenderName());
            ps.setString(2, message.getRecipientName());
            ps.setString(3, message.getMessageContent());
            ps.setLong(4, message.getDate());
            if (contains_id) {
                ps.setLong(5, message.getId());
            }
            ps.executeUpdate();
            if (!contains_id) {
                ResultSet keys = ps.getGeneratedKeys();
                if (keys.isBeforeFirst()) {
                    keys.next();
                    long new_id = keys.getLong(1);
                    message.setId(new_id);
                } else {
                    throw new SQLException("Cannot get unique ID for newly created Message object. Check database setup & connection");
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getUnreadMessagesWithRecipient(String recipient_name) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_unread_messages WHERE RECIPIENT = ? ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, recipient_name);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getUnreadMessagesWithSender(String sender_name) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_unread_messages WHERE SENDER = ? ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, sender_name);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMessage(Message message) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean update = this.messageExists(message.getId());
        boolean contains_id = message.getId() != -1L;
        try {
            conn = this.ds.getConnection();
            String query = update ? "UPDATE pmsg_messages_history SET SENDER = ?, RECIPIENT = ?, MESSAGE = ?, DATE = ? WHERE ID = ?" : (contains_id ? "INSERT INTO pmsg_messages_history (SENDER, RECIPIENT, MESSAGE, DATE, ID) VALUES (?, ?, ?, ?, ?)" : "INSERT INTO pmsg_messages_history (SENDER, RECIPIENT, MESSAGE, DATE) VALUES (?, ?, ?, ?)");
            ps = conn.prepareStatement(query, 1);
            ps.setString(1, message.getSenderName());
            ps.setString(2, message.getRecipientName());
            ps.setString(3, message.getMessageContent());
            ps.setLong(4, message.getDate());
            if (contains_id) {
                ps.setLong(5, message.getId());
            }
            ps.executeUpdate();
            if (!contains_id) {
                ResultSet keys = ps.getGeneratedKeys();
                if (keys.isBeforeFirst()) {
                    keys.next();
                    long new_id = keys.getLong(1);
                    message.setId(new_id);
                } else {
                    throw new SQLException("Cannot get unique ID for newly created Message object. Check database setup & connection");
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(conn, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean messageExists(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE ID = ?";
        boolean exists = false;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            exists = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessageFromHistory(Long id) {
        Message message = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE ID = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return message;
    }

    @Override
    public List<Message> getMessagesFromHistory(Iterable<Long> ids) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Long id : ids) {
            Message message = this.getMessageFromHistory(id);
            if (message == null) continue;
            messages.add(this.getMessageFromHistory(id));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistory(String player1, String player2) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?) ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player1);
            ps.setString(2, player2);
            ps.setString(3, player2);
            ps.setString(4, player1);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistory(String player) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE SENDER = ? OR RECIPIENT = ? ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player);
            ps.setString(2, player);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistory() {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistoryRelativeToDate(Long timestamp, DateRelationType dateRelationType) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = null;
        switch (dateRelationType) {
            case AFTER: {
                query = "SELECT * FROM pmsg_messages_history WHERE (DATE > ?) ORDER BY DATE DESC";
                break;
            }
            case BEFORE: {
                query = "SELECT * FROM pmsg_messages_history WHERE (DATE < ?) ORDER BY DATE DESC";
                break;
            }
            case SINCE: {
                query = "SELECT * FROM pmsg_messages_history WHERE (DATE >= ?) ORDER BY DATE DESC";
                break;
            }
            case TO: {
                query = "SELECT * FROM pmsg_messages_history WHERE (DATE <= ?) ORDER BY DATE DESC";
            }
        }
        if (query == null) {
            return messages;
        }
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, timestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistoryInDatesRange(Long startTimestamp, Long endTimestamp) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE (DATE >= ? AND DATE <= ?) ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, startTimestamp);
            ps.setLong(2, endTimestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPlayerMessagesFromHistoryRelativeToDate(String playerName, Long timestamp, DateRelationType dateRelationType) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = null;
        switch (dateRelationType) {
            case AFTER: {
                query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? OR RECIPIENT = ?) AND DATE > ? ORDER BY DATE DESC";
                break;
            }
            case BEFORE: {
                query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? OR RECIPIENT = ?) AND DATE < ? ORDER BY DATE DESC";
                break;
            }
            case SINCE: {
                query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? OR RECIPIENT = ?) AND DATE >= ? ORDER BY DATE DESC";
                break;
            }
            case TO: {
                query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? OR RECIPIENT = ?) AND DATE <= ? ORDER BY DATE DESC";
            }
        }
        if (query == null) {
            return messages;
        }
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            ps.setString(2, playerName);
            ps.setLong(3, timestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPlayersPairMessagesFromHistoryRelativeToDate(String player1Name, String player2Name, Long timestamp, DateRelationType dateRelationType) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = null;
        switch (dateRelationType) {
            case AFTER: {
                query = "SELECT * FROM pmsg_messages_history WHERE ((SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?)) AND DATE > ? ORDER BY DATE DESC";
                break;
            }
            case BEFORE: {
                query = "SELECT * FROM pmsg_messages_history WHERE ((SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?)) AND DATE < ? ORDER BY DATE DESC";
                break;
            }
            case SINCE: {
                query = "SELECT * FROM pmsg_messages_history WHERE ((SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?)) AND DATE >= ? ORDER BY DATE DESC";
                break;
            }
            case TO: {
                query = "SELECT * FROM pmsg_messages_history WHERE ((SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?)) AND DATE <= ? ORDER BY DATE DESC";
            }
        }
        if (query == null) {
            return messages;
        }
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player1Name);
            ps.setString(2, player2Name);
            ps.setString(3, player2Name);
            ps.setString(4, player1Name);
            ps.setLong(5, timestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPlayersPairMessagesFromHistoryInDatesRange(String player1Name, String player2Name, Long startTimestamp, Long endTimestamp) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE ((SENDER = ? AND RECIPIENT = ?) OR (SENDER = ? AND RECIPIENT = ?)) AND (DATE >= ?) AND (DATE <= ?) ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player1Name);
            ps.setString(2, player2Name);
            ps.setString(3, player2Name);
            ps.setString(4, player1Name);
            ps.setLong(5, startTimestamp);
            ps.setLong(6, endTimestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPlayerMessagesFromHistoryInDatesRange(String playerName, Long startTimestamp, Long endTimestamp) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_messages_history WHERE (SENDER = ? OR RECIPIENT = ?) AND (DATE >= ? AND DATE <= ?) ORDER BY DATE DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            ps.setString(2, playerName);
            ps.setLong(3, startTimestamp);
            ps.setLong(4, endTimestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("ID"), rs.getString("SENDER"), rs.getString("RECIPIENT"), rs.getLong("DATE"), rs.getString("MESSAGE"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PlayerSettings> loadAllPlayerSettings() {
        HashMap<String, PlayerSettings> settingsData = new HashMap<String, PlayerSettings>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_player_settings";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                Long id = rs.getLong("ID");
                String player_name = rs.getString("PLAYER_NAME");
                int notification_sound_number = rs.getInt("SOUND_NUMBER");
                Set<String> ignored_players = StringUtils.getSetFromString(rs.getString("IGNORED_PLAYERS"));
                boolean sound_enabled = MainUtils.getBoolVal(rs.getInt("SOUND_ENABLED"));
                boolean spy_enabled = MainUtils.getBoolVal(rs.getInt("SPY_ENABLED"));
                boolean pmsg_enabled = MainUtils.getBoolVal(rs.getInt("PRIVATE_MESSAGES_ENABLED"));
                boolean tips_enabled = MainUtils.getBoolVal(rs.getInt("PLUGIN_TIPS_ENABLED"));
                int unread_messages_tips_count = rs.getInt("UNREAD_MESSAGES_TIPS_COUNT");
                int notification_sound_tips_count = rs.getInt("NOTIFICATION_SOUND_TIPS_COUNT");
                PlayerSettings data = new PlayerSettings();
                data.load(id, player_name, notification_sound_number, sound_enabled, spy_enabled, ignored_players, pmsg_enabled, tips_enabled, unread_messages_tips_count, notification_sound_tips_count);
                settingsData.put(data.getPlayerName(), data);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return settingsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlayerSettings getPlayerSettings(String player_name) {
        PlayerSettings data = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_player_settings WHERE PLAYER_NAME = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, player_name);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                data = new PlayerSettings();
                Long id = rs.getLong("ID");
                int sound_number = rs.getInt("SOUND_NUMBER");
                String name = rs.getString("PLAYER_NAME");
                Set<String> ignored_players = StringUtils.getSetFromString(rs.getString("IGNORED_PLAYERS"));
                boolean sound_enabled = MainUtils.getBoolVal(rs.getInt("SOUND_ENABLED"));
                boolean spy_enabled = MainUtils.getBoolVal(rs.getInt("SPY_ENABLED"));
                boolean msg_enabled = MainUtils.getBoolVal(rs.getInt("PRIVATE_MESSAGES_ENABLED"));
                boolean tips_enabled = MainUtils.getBoolVal(rs.getInt("PLUGIN_TIPS_ENABLED"));
                int unread_messages_tips_count = rs.getInt("UNREAD_MESSAGES_TIPS_COUNT");
                int notification_sound_tips_count = rs.getInt("NOTIFICATION_SOUND_TIPS_COUNT");
                data.load(id, name, sound_number, sound_enabled, spy_enabled, ignored_players, msg_enabled, tips_enabled, unread_messages_tips_count, notification_sound_tips_count);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlayerSettings getPlayerSettings(Long id) {
        PlayerSettings data = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_player_settings WHERE ID = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                data = new PlayerSettings();
                int sound_number = rs.getInt("SOUND_NUMBER");
                String name = rs.getString("PLAYER_NAME");
                Set<String> ignored_players = StringUtils.getSetFromString(rs.getString("IGNORED_PLAYERS"));
                boolean sound_enabled = MainUtils.getBoolVal(rs.getInt("SOUND_ENABLED"));
                boolean spy_enabled = MainUtils.getBoolVal(rs.getInt("SPY_ENABLED"));
                boolean msg_enabled = MainUtils.getBoolVal(rs.getInt("PRIVATE_MESSAGES_ENABLED"));
                boolean tips_enabled = MainUtils.getBoolVal(rs.getInt("PLUGIN_TIPS_ENABLED"));
                int unread_messages_tips_count = rs.getInt("UNREAD_MESSAGES_TIPS_COUNT");
                int notification_sound_tips_count = rs.getInt("NOTIFICATION_SOUND_TIPS_COUNT");
                data.load(id, name, sound_number, sound_enabled, spy_enabled, ignored_players, msg_enabled, tips_enabled, unread_messages_tips_count, notification_sound_tips_count);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerSettings(PlayerSettings data) {
        boolean contains_id;
        Connection conn = null;
        PreparedStatement ps = null;
        boolean update = this.playerSettingsExists(data.getId());
        boolean bl = contains_id = data.getId() != -1L;
        String query = update ? "UPDATE pmsg_player_settings SET PLAYER_NAME = ?, SOUND_NUMBER = ?, SOUND_ENABLED = ?, SPY_ENABLED = ?, IGNORED_PLAYERS = ?, PRIVATE_MESSAGES_ENABLED = ?, PLUGIN_TIPS_ENABLED = ?, NOTIFICATION_SOUND_TIPS_COUNT = ?,  UNREAD_MESSAGES_TIPS_COUNT = ? WHERE ID = ?" : (contains_id ? "INSERT INTO pmsg_player_settings (PLAYER_NAME, SOUND_NUMBER, SOUND_ENABLED, SPY_ENABLED, IGNORED_PLAYERS, PRIVATE_MESSAGES_ENABLED, PLUGIN_TIPS_ENABLED, NOTIFICATION_SOUND_TIPS_COUNT, UNREAD_MESSAGES_TIPS_COUNT, ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO pmsg_player_settings (PLAYER_NAME, SOUND_NUMBER, SOUND_ENABLED, SPY_ENABLED, IGNORED_PLAYERS, PRIVATE_MESSAGES_ENABLED, PLUGIN_TIPS_ENABLED, NOTIFICATION_SOUND_TIPS_COUNT, UNREAD_MESSAGES_TIPS_COUNT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query, 1);
            ps.setString(1, data.getPlayerName());
            ps.setInt(2, data.getMessageNotificationSoundNumber());
            ps.setInt(3, MainUtils.getIntVal(data.isMessageNotificationSoundEnabled()));
            ps.setInt(4, MainUtils.getIntVal(data.isMessageSpyEnabled()));
            ps.setString(5, StringUtils.getStringFromSet(data.getIgnoredPlayers()));
            ps.setInt(6, MainUtils.getIntVal(data.arePrivateMessagesEnabled()));
            ps.setInt(7, MainUtils.getIntVal(data.arePluginTipsEnabled()));
            ps.setInt(8, data.getNotificationSoundTipsCount());
            ps.setInt(9, data.getUnreadMessagesTipsCount());
            if (contains_id) {
                ps.setLong(10, data.getId());
            }
            ps.executeUpdate();
            if (!contains_id) {
                ResultSet keys = ps.getGeneratedKeys();
                if (keys.isBeforeFirst()) {
                    keys.next();
                    long new_id = keys.getLong(1);
                    data.setId(new_id);
                } else {
                    throw new SQLException("Cannot get unique ID for newly created PlayerSettings object. Check database setup & connection");
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayerSettings(String playerName) {
        Connection conn = null;
        PreparedStatement ps = null;
        if (this.playerSettingsExists(playerName)) {
            String query = "DELETE FROM pmsg_player_settings WHERE PLAYER_NAME = ?";
            try {
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(query);
                ps.setString(1, playerName);
                ps.executeUpdate();
                this.close(conn, ps, null);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    this.close(conn, ps, null);
                }
                catch (Throwable throwable) {
                    this.close(conn, ps, null);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePlayerMessages(String playerName) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM pmsg_messages_history WHERE RECIPIENT = ? OR SENDER = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            ps.setString(2, playerName);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllMessages() {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM pmsg_messages_history";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM pmsg_messages_history WHERE ID = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessages(List<Message> messages) {
        for (Message message : messages) {
            this.deleteMessage(message.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean playerSettingsExists(String playerName) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean result = false;
        String query = "SELECT * FROM pmsg_player_settings WHERE PLAYER_NAME = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            rs = ps.executeQuery();
            result = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean playerSettingsExists(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean result = false;
        String query = "SELECT * FROM pmsg_player_settings WHERE ID = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            result = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unreadMessageExists(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM pmsg_unread_messages WHERE ID = ?";
        boolean exists = false;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            exists = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnreadMessagesWithRecipient(String playerName) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM pmsg_unread_messages WHERE RECIPIENT = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnreadMessagesWithSender(String playerName) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM pmsg_unread_messages WHERE SENDER = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, playerName);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEssentialsIgnoreData(Map<String, List<String>> ignores) {
        if (ignores == null || ignores.isEmpty()) {
            return;
        }
        String ignoresStr = StringUtils.getStringFromMap(ignores);
        if (ignoresStr.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "INSERT INTO pmsg_integrations_data (ESSENTIALS_IGNORES) VALUES (?)";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setString(1, ignoresStr);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }
}

