/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.tabcompleters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.utils.MainUtils;

public class HistoryTabCompleter
implements TabCompleter {
    private PrivateMessages instance;

    public HistoryTabCompleter(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> complete = new ArrayList<String>();
        if (!sender.hasPermission("pm.history")) {
            return complete;
        }
        if (args.length == 1) {
            complete = MainUtils.getApplicablePlayerCompletions(sender, args[0]);
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            }
            if (sender.hasPermission("pm.admin")) {
                complete.add("*");
                complete.add("-query");
            }
        } else if (args.length == 2) {
            complete = MainUtils.getApplicablePlayerCompletions(sender, args[1]);
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            }
            if (sender.hasPermission("pm.admin")) {
                if (!args[0].equalsIgnoreCase("-query") && !args[0].equalsIgnoreCase("-q")) {
                    complete.add("*");
                } else {
                    complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAMES_PAIR);
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_ID);
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_IDS_GROUP);
                }
            }
        } else if (args.length == 3 && sender.hasPermission("pm.admin")) {
            if (args[1].equalsIgnoreCase("before") || args[1].equalsIgnoreCase("after") || args[1].equalsIgnoreCase("since") || args[1].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[1].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (!MainUtils.isInteger(args[1]) && !args[1].equalsIgnoreCase("ALL")) {
                complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
            }
        } else if (args.length == 4 && sender.hasPermission("pm.admin")) {
            if (args[2].equalsIgnoreCase("before") || args[2].equalsIgnoreCase("after") || args[2].equalsIgnoreCase("since") || args[2].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[2].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (args[1].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
            }
        } else if (args.length == 5 && sender.hasPermission("pm.admin") && args[2].equalsIgnoreCase("range")) {
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
        }
        return complete;
    }
}

