/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatCompatUtil {
    private static final boolean ADVENTURE_AVAILABLE;
    private static final Method SEND_COMPONENT_METHOD;

    public static void send(CommandSender recipient, String legacyMessage, Object adventureComponent) {
        if (ADVENTURE_AVAILABLE && adventureComponent != null) {
            try {
                SEND_COMPONENT_METHOD.invoke((Object)recipient, adventureComponent);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (legacyMessage != null) {
            recipient.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)legacyMessage));
        }
    }

    static {
        boolean found = false;
        Method method = null;
        try {
            Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
            method = Player.class.getMethod("sendMessage", componentClass);
            found = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        ADVENTURE_AVAILABLE = found;
        SEND_COMPONENT_METHOD = method;
    }
}

