/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCompatUtil {
    private static final boolean ADVENTURE_AVAILABLE;
    private static final Method ITEMMETA_SET_DISPLAYNAME_METHOD;
    private static final Method ITEMMETA_SET_LORE_METHOD;

    public static ItemMeta setDisplayName(ItemMeta meta, String legacyDisplayName, Object adventureComponent) {
        if (ADVENTURE_AVAILABLE && adventureComponent != null) {
            try {
                ITEMMETA_SET_DISPLAYNAME_METHOD.invoke((Object)meta, adventureComponent);
                return meta;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (legacyDisplayName != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)legacyDisplayName));
        }
        return meta;
    }

    public static ItemMeta setLore(ItemMeta meta, List<String> legacyLore, List<?> adventureComponents) {
        if (ADVENTURE_AVAILABLE && adventureComponents != null) {
            try {
                ITEMMETA_SET_LORE_METHOD.invoke((Object)meta, adventureComponents);
                return meta;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (legacyLore != null) {
            ArrayList<String> formatted_lore = new ArrayList<String>();
            for (String line : legacyLore) {
                String formatted_line = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
                formatted_lore.add(formatted_line);
            }
            meta.setLore(formatted_lore);
        }
        return meta;
    }

    static {
        Method meta_displayname_method = null;
        Method meta_lore_method = null;
        Class<?> componentClass = null;
        try {
            componentClass = Class.forName("net.kyori.adventure.text.Component");
            meta_displayname_method = ItemMeta.class.getMethod("customName", componentClass);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (meta_displayname_method == null) {
            try {
                componentClass = Class.forName("net.kyori.adventure.text.Component");
                meta_displayname_method = ItemMeta.class.getMethod("displayName", componentClass);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            componentClass = Class.forName("net.kyori.adventure.text.Component");
            meta_lore_method = ItemMeta.class.getMethod("lore", List.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        ADVENTURE_AVAILABLE = meta_displayname_method != null && meta_lore_method != null;
        ITEMMETA_SET_DISPLAYNAME_METHOD = meta_displayname_method;
        ITEMMETA_SET_LORE_METHOD = meta_lore_method;
    }
}

