/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.bukkit.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.bukkit.PrivateMessages;
import pl.mirotcz.privatemessages.bukkit.data.DateRelationType;
import pl.mirotcz.privatemessages.bukkit.data.MessagesRetrievalError;
import pl.mirotcz.privatemessages.bukkit.data.MessagesRetrievalResult;
import pl.mirotcz.privatemessages.bukkit.data.PlayerTempData;
import pl.mirotcz.privatemessages.bukkit.inventories.SoundInventory;
import pl.mirotcz.privatemessages.bukkit.items.ItemMetaEditor;
import pl.mirotcz.privatemessages.bukkit.utils.DateUtils;
import pl.mirotcz.privatemessages.bukkit.utils.StringUtils;

public class MainUtils {
    public static void reloadPlugin() {
        PrivateMessages.get().getManagers().getConfigManagers().reloadConfigs();
        PrivateMessages.get().getMessages().load();
        PrivateMessages.get().getSettings().load();
        PrivateMessages.get().getManagers().getSoundConfigurationsManager().load();
        PrivateMessages.get().setupMessenger();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerTempData tempData = PrivateMessages.get().getManagers().getPlayerTempDataManger().getData(player.getName());
            SoundInventory soundInv = tempData.getLastSoundInventory();
            if (soundInv == null) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PrivateMessages.get(), () -> soundInv.load());
        }
    }

    public static List<String> getApplicablePlayerCompletions(CommandSender sender, String playerArg) {
        ArrayList<String> completions = new ArrayList<String>();
        boolean first_arg_not_empty = playerArg != null && !playerArg.isEmpty();
        boolean vanish_support = PrivateMessages.get().getManagers().getIntegrationManager().isVanishSupported();
        boolean sender_vanish_bypass = sender.hasPermission("pm.vanishbypass");
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (vanish_support && PrivateMessages.get().getVanish().isVanished(player) && !sender_vanish_bypass || sender instanceof Player && !((Player)sender).canSee(player) && !sender_vanish_bypass) continue;
            if (first_arg_not_empty) {
                if (!player.getName().toLowerCase().startsWith(playerArg.toLowerCase())) continue;
                completions.add(player.getName());
                continue;
            }
            completions.add(player.getName());
        }
        return completions;
    }

    public static int getIntVal(boolean value) {
        return value ? 1 : 0;
    }

    public static boolean getBoolVal(int value) {
        return value == 1;
    }

    public static int getRandomInt(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static List<String> getColorfulStringList(List<String> list) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : list) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        return lore;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static OfflinePlayer getOfflinePlayer(String name, OfflinePlayer[] players) {
        for (OfflinePlayer op : players) {
            if (!op.getName().equalsIgnoreCase(name)) continue;
            return op;
        }
        return null;
    }

    public static boolean containsIgnoreCase(List<String> list, String value) {
        for (String text : list) {
            if (!text.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static LocalDateTime getLocalDateTimeFromCommandString(String dateTimeStr) {
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter formatter : PrivateMessages.get().getSettings().IN_COMMAND_DATETIME_FORMATTERS) {
            try {
                localDateTime = LocalDateTime.parse(dateTimeStr, formatter);
                return localDateTime;
            }
            catch (DateTimeParseException e) {
            }
        }
        return localDateTime;
    }

    public static MessagesRetrievalResult getMessagesMatchingExpression(String expression) {
        String startDateTimeStr;
        String[] namesPair;
        long timestamp = 0L;
        List<Message> messages = new ArrayList<Message>();
        String[] parts = expression.split(" ");
        boolean allMessagesOnServer = false;
        if (parts.length == 0) {
            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
        }
        if (parts.length == 1) {
            if (parts[0].equalsIgnoreCase("ALL")) {
                messages = PrivateMessages.get().getStorage().getMessagesFromHistory();
                allMessagesOnServer = true;
            } else {
                String[] ids = parts[0].split(",");
                ArrayList<Long> idsList = new ArrayList<Long>();
                for (String id : ids) {
                    try {
                        Long msgId = Long.parseLong(id);
                        idsList.add(msgId);
                    }
                    catch (NumberFormatException ex) {
                        return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_MESSAGE_ID);
                    }
                }
                messages = PrivateMessages.get().getStorage().getMessagesFromHistory(idsList);
            }
        } else if (parts.length == 2) {
            namesPair = parts[0].split(",");
            if (namesPair.length > 2) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
            }
            boolean isNamesPair = namesPair.length == 2;
            String player1 = namesPair[0];
            String player2 = null;
            if (isNamesPair) {
                player2 = namesPair[1];
            }
            if (parts[1].equalsIgnoreCase("ALL")) {
                messages = !isNamesPair ? PrivateMessages.get().getStorage().getMessagesFromHistory(player1) : PrivateMessages.get().getStorage().getMessagesFromHistory(player1, player2);
            } else {
                boolean isValidDateTimePresent = true;
                String dateTimeStr = parts[1];
                Instant instant = null;
                LocalDateTime localDateTime = MainUtils.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                instant = localDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                switch (parts[0].toUpperCase()) {
                    case "BEFORE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.BEFORE);
                        break;
                    }
                    case "AFTER": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.AFTER);
                        break;
                    }
                    case "TO": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.TO);
                        break;
                    }
                    case "SINCE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = PrivateMessages.get().getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.SINCE);
                    }
                }
            }
        } else if (parts.length == 3) {
            if (parts[0].equalsIgnoreCase("RANGE")) {
                startDateTimeStr = parts[1];
                String endDateTimeStr = parts[2];
                Instant endInstant = null;
                LocalDateTime startLocalDateTime = MainUtils.getLocalDateTimeFromCommandString(startDateTimeStr);
                LocalDateTime endLocalDateTime = MainUtils.getLocalDateTimeFromCommandString(endDateTimeStr);
                if (startLocalDateTime == null || endLocalDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant startInstant = startLocalDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
                endInstant = endLocalDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
                long startTimestamp = startInstant.toEpochMilli();
                long endTimestamp = endInstant.toEpochMilli();
                messages = PrivateMessages.get().getStorage().getMessagesFromHistoryInDatesRange(startTimestamp, endTimestamp);
            } else {
                namesPair = parts[0].split(",");
                String dateTimeStr = parts[2];
                LocalDateTime localDateTime = MainUtils.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant instant = localDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                if (namesPair.length < 2) {
                    String playerName = parts[0];
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = PrivateMessages.get().getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = PrivateMessages.get().getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = PrivateMessages.get().getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = PrivateMessages.get().getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.SINCE);
                        }
                    }
                } else {
                    String player1 = namesPair[0];
                    String player2 = namesPair[1];
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = PrivateMessages.get().getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = PrivateMessages.get().getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = PrivateMessages.get().getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = PrivateMessages.get().getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.SINCE);
                        }
                    }
                }
            }
        } else if (parts.length == 4 && parts[1].equalsIgnoreCase("RANGE")) {
            startDateTimeStr = parts[2];
            String endDateTimeStr = parts[3];
            Instant endInstant = null;
            LocalDateTime startLocalDateTime = MainUtils.getLocalDateTimeFromCommandString(startDateTimeStr);
            LocalDateTime endLocalDateTime = MainUtils.getLocalDateTimeFromCommandString(endDateTimeStr);
            if (startLocalDateTime == null || endLocalDateTime == null) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
            }
            Instant startInstant = startLocalDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
            endInstant = endLocalDateTime.atZone(ZoneId.of(PrivateMessages.get().getSettings().TIME_ZONE)).toInstant();
            long startTimestamp = startInstant.toEpochMilli();
            long endTimestamp = endInstant.toEpochMilli();
            String[] namesPair2 = parts[0].split(",");
            if (namesPair2.length < 2) {
                String playerName = parts[0];
                messages = PrivateMessages.get().getStorage().getPlayerMessagesFromHistoryInDatesRange(playerName, startTimestamp, endTimestamp);
            } else {
                String player1 = namesPair2[0];
                String player2 = namesPair2[1];
                messages = PrivateMessages.get().getStorage().getPlayersPairMessagesFromHistoryInDatesRange(player1, player2, startTimestamp, endTimestamp);
            }
        }
        MessagesRetrievalResult result = new MessagesRetrievalResult(messages);
        if (allMessagesOnServer) {
            result.markContainsAllStoredMessages();
        }
        return result;
    }

    public static ItemStack getMessageItem(Message message) {
        return MainUtils.getMessageItem(message, null, false);
    }

    public static ItemStack getMessageItem(Message message, Player player) {
        return MainUtils.getMessageItem(message, player, false);
    }

    public static ItemStack getMessageItem(Message message, Player player, boolean showActionsTip) {
        ItemMetaEditor itemMetaEditor = PrivateMessages.get().getItemMetaEditor();
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_NAME.replaceAll("<sender>", message.getSenderName()).replaceAll("<recipient>", message.getRecipientName()));
        String message_content = message.getMessageContent();
        if (message_content.length() > 30) {
            List<String> words = StringUtils.getWordsFromMessage(message_content);
            String line = "";
            for (int i = 1; i <= words.size(); ++i) {
                line = line + words.get(i - 1);
                if (i + 1 <= words.size()) {
                    if (line.length() + words.get(i).length() < 30) continue;
                    lore.add(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", line));
                    line = "";
                    continue;
                }
                lore.add(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", line));
                line = "";
            }
        } else {
            lore.add(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", message_content));
        }
        if (showActionsTip && player != null && player.hasPermission("pm.actions")) {
            lore.addAll(PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MORE);
        }
        meta = itemMetaEditor.setLore(meta, lore);
        meta = itemMetaEditor.setDisplayName(meta, PrivateMessages.get().getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_DATE.replaceAll("<date>", DateUtils.getFormattedDate(message.getDate(), PrivateMessages.get().getSettings().MESSAGES_HISTORY_DATETIME_FORMATTER)));
        item.setItemMeta(meta);
        return item;
    }
}

