/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;
import pl.mirotcz.privatemessages.velocity.events.PrivateMessageEvent;
import pl.mirotcz.privatemessages.velocity.utils.StringUtils;

public class MessageSending {
    private PrivateMessages instance;

    public MessageSending(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void sendMessage(CommandSource sender, Player recipient, String recipientName, boolean known_recipient_name, boolean offline, boolean vanish, String[] args) {
        String senderName;
        if (recipient == sender && !this.instance.getSettings().ALLOW_SENDING_MESSAGES_TO_SELF) {
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_CANNOT_MESSAGE_SELF);
            return;
        }
        if (recipient == null && !known_recipient_name) {
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
            return;
        }
        boolean isSenderConsole = !(sender instanceof Player);
        String string = senderName = !isSenderConsole ? ((Player)sender).getUsername() : this.instance.getMessages().CONSOLE_SENDER_NAME;
        if (!isSenderConsole) {
            PlayerSettings recipientSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(recipientName);
            PlayerSettings senderSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(senderName);
            if ((recipientSettings.getIgnoredPlayers().contains(senderName) || this.instance.getSettings().ESSENTIALS_IGNORE_RESPECT && this.instance.getUtils().getMainUtils().isIgnoredOnSupportedIntegrations(senderName, recipientName)) && !sender.hasPermission("pm.message.ignored")) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_IGNORES_YOU);
                return;
            }
            if ((senderSettings.getIgnoredPlayers().contains(recipientName) || this.instance.getSettings().ESSENTIALS_IGNORE_RESPECT && this.instance.getUtils().getMainUtils().isIgnoredOnSupportedIntegrations(recipientName, senderName)) && !sender.hasPermission("pm.message.ignored")) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_IGNORED);
                return;
            }
            if (!recipientSettings.arePrivateMessagesEnabled() && !sender.hasPermission("pm.message.disabled")) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_MESSAGES_DISABLED);
                return;
            }
            if (!senderSettings.arePrivateMessagesEnabled() && !sender.hasPermission("pm.message.disabled")) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_DISABLED);
                return;
            }
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 && args[i].equalsIgnoreCase(recipientName)) continue;
            text.append(args[i]);
            if (i + 1 >= args.length) continue;
            text.append(" ");
        }
        String final_text = StringUtils.getSafeString(text.toString());
        Message message = new Message(senderName, recipientName, System.currentTimeMillis(), final_text);
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> this.instance.getServer().getEventManager().fireAndForget((Object)new PrivateMessageEvent(message))).delay(50L, TimeUnit.MILLISECONDS).schedule();
        boolean vanishBypass = false;
        if (!vanish) {
            if (!offline) {
                this.instance.getMessenger().sendCustomPrefix(sender, "", this.instance.getMessages().MESSAGE_TO_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
            } else {
                this.instance.getMessenger().sendCustomPrefix(sender, "", this.instance.getMessages().MESSAGE_TO_OFFLINE_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
            }
        } else if (sender.hasPermission("pm.vanishbypass")) {
            this.instance.getMessenger().sendCustomPrefix(sender, "", this.instance.getMessages().MESSAGE_TO_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
            vanishBypass = true;
        } else {
            this.instance.getMessenger().sendCustomPrefix(sender, "", this.instance.getMessages().MESSAGE_TO_OFFLINE_FORMAT.replaceAll("<player>", message.getRecipientName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
        }
        if (recipient != null && recipient.isActive()) {
            if (!vanish || vanish && vanishBypass) {
                this.notifyPlayerMessage(message);
            } else if (this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                this.instance.getManagers().getPendingMessagesManager().addPendingUnreadMessage(message);
            }
        } else if (this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
            this.instance.getManagers().getPendingMessagesManager().addPendingUnreadMessage(message);
        }
        if (recipient != null) {
            this.instance.getManagers().getPlayerTempDataManger().getData(recipient.getUsername()).setLastMessageSender(senderName);
        }
        if (sender instanceof Player) {
            this.instance.getManagers().getPlayerTempDataManger().getData(senderName).setLastMessageSender(recipientName);
        }
        if (this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
            this.instance.getManagers().getPendingMessagesManager().addPendingMessage(message);
        }
        if (!vanish) {
            this.instance.getManagers().getListenersManager().getPluginMessagesListener().sendSoundNotify(recipientName);
        }
    }

    public void notifyPlayerMessage(Message message) {
        Player recipient = this.instance.getServer().getPlayer(message.getRecipientName()).orElse(null);
        if (recipient != null) {
            this.instance.getMessenger().sendCustomPrefix((CommandSource)recipient, "", this.instance.getMessages().MESSAGE_FROM_FORMAT.replaceAll("<player>", message.getSenderName()).replaceAll("<sender>", message.getSenderName()).replaceAll("<message>", message.getMessageContent()));
        }
    }
}

