/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;

public class NotifierTask {
    private PrivateMessages instance;
    private ScheduledTask task = null;
    private volatile ConcurrentLinkedQueue<String> players_waiting_for_notification = new ConcurrentLinkedQueue();

    public NotifierTask(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void start() {
        this.task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            Iterator<String> it = this.players_waiting_for_notification.iterator();
            while (it.hasNext()) {
                String player_name = it.next();
                int count = 0;
                for (Message m : this.instance.getManagers().getPendingMessagesManager().getPendingUnreadMessages()) {
                    if (!m.getRecipientName().equalsIgnoreCase(player_name)) continue;
                    ++count;
                }
                int stored_unread_messages = this.instance.getStorage().getUnreadMessagesWithRecipient(player_name).size();
                if ((count += stored_unread_messages) > 0) {
                    this.instance.getMessenger().send((CommandSource)this.instance.getServer().getPlayer(player_name).orElse(null), this.instance.getMessages().INFO_YOU_HAVE_UNREAD_MESSAGES.replaceAll("<number>", String.valueOf(count)));
                }
                it.remove();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).delay(2L, TimeUnit.SECONDS).repeat(2L, TimeUnit.SECONDS).schedule();
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void addPlayerWaitingForNotification(String name) {
        if (!this.players_waiting_for_notification.contains(name)) {
            this.players_waiting_for_notification.add(name);
        }
    }
}

