/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.slf4j.Logger;
import pl.mirotcz.charts.SimplePie;
import pl.mirotcz.privatemessages.velocity.MessageSending;
import pl.mirotcz.privatemessages.velocity.NotifierTask;
import pl.mirotcz.privatemessages.velocity.Utils;
import pl.mirotcz.privatemessages.velocity.VanishInfoUpdaterTask;
import pl.mirotcz.privatemessages.velocity.data.ConsoleSenderTempData;
import pl.mirotcz.privatemessages.velocity.managers.Managers;
import pl.mirotcz.privatemessages.velocity.managers.MessagesManager;
import pl.mirotcz.privatemessages.velocity.managers.SettingsManager;
import pl.mirotcz.privatemessages.velocity.messaging.Messenger;
import pl.mirotcz.privatemessages.velocity.storage.Storage;
import pl.mirotcz.privatemessages.velocity.vanish.Vanish;
import pl.mirotcz.velocity.Metrics;

@Plugin(id="privatemessages", name="PrivateMessages", description="Advanced private messaging plugin", version="3.1", authors={"MiroTcz"})
public class PrivateMessages {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private static PrivateMessages instance;
    private Managers managers;
    private MessageSending message_sending;
    private Utils utils;
    private NotifierTask notifier_task;
    private VanishInfoUpdaterTask vanish_task;
    private Messenger messenger;
    private Metrics metrics;
    private final ConsoleSenderTempData consoleSenderTempData = new ConsoleSenderTempData();

    @Inject
    public PrivateMessages(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.managers = new Managers(instance);
        this.managers.load();
        this.message_sending = new MessageSending(instance);
        this.messenger = new Messenger();
        this.messenger.setDefaultPrefix(this.getMessages().PLUGIN_PREFIX);
        this.utils = new Utils(instance);
        this.utils.load();
        this.notifier_task = new NotifierTask(instance);
        this.notifier_task.start();
        if (instance.getManagers().getIntegrationsManager().isVanishSupported()) {
            this.getLogger().info("Vanish provider found! Using " + this.managers.getIntegrationsManager().getUsedVanishPluginName());
            this.vanish_task = new VanishInfoUpdaterTask(instance);
            this.vanish_task.startTask();
        } else {
            instance.getLogger().info("No vanish provider found. Will try to obtain vanish info from backend servers.");
        }
        this.startMetricsIfEnabled();
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.getManagers().getIntegrationsManager().stopEssentialsIgnoresUpdaterTask();
        this.getManagers().getPendingMessagesManager().savePendingMessagesToStorage();
        this.getManagers().getPendingMessagesManager().savePendingUnreadMessagesToStorage();
        this.getManagers().getPendingMessagesManager().cancelSaveTask();
        this.getManagers().getPlayerSettingsManager().savePendingChanges();
        this.getManagers().getPlayerSettingsManager().cancelSaveTask();
        this.getManagers().getKnownPlayersManager().saveKnownPlayers(this.getManagers().getConfigManagers().getKnownPlayersConfigManager());
        this.getManagers().getKnownPlayersManager().stopTask();
        this.getStorage().clearVansihedPlayersInfo();
        this.getStorage().clearPlayerWaitingForSettingsReloadTable();
        this.getStorage().closePool();
        if (this.notifier_task != null) {
            this.notifier_task.stop();
        }
        if (this.vanish_task != null) {
            this.vanish_task.stopTask();
        }
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Managers getManagers() {
        return this.managers;
    }

    public MessagesManager getMessages() {
        return this.getManagers().getMessagesManager();
    }

    public SettingsManager getSettings() {
        return this.getManagers().getSettingsManager();
    }

    public Storage getStorage() {
        return this.getManagers().getStorageManager().getStorage();
    }

    public Vanish getVanish() {
        return this.getManagers().getIntegrationsManager().getVanish();
    }

    public MessageSending getMessageSending() {
        return this.message_sending;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public NotifierTask getNotifierTask() {
        return this.notifier_task;
    }

    public VanishInfoUpdaterTask getVanishTask() {
        return this.vanish_task;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleSenderTempData getConsoleSenderTempData() {
        return this.consoleSenderTempData;
    }

    private void startMetricsIfEnabled() {
        if (this.getSettings().METRICS) {
            this.metrics = this.metricsFactory.make(this, 25071);
            this.metrics.addCustomChart(new SimplePie("vanish_integration", () -> String.valueOf(this.getVanish() != null)));
        }
    }
}

