/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.Map;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.managers.IntegrationsManager;
import pl.mirotcz.privatemessages.velocity.storage.Storage_MySQL;

public class VanishInfoUpdaterTask {
    private PrivateMessages instance;
    private ScheduledTask task = null;

    public VanishInfoUpdaterTask(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void startTask() {
        this.task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> this.loadAndUpdateVanishedPlayers()).schedule();
    }

    public void stopTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void loadAndUpdateVanishedPlayers() {
        Storage_MySQL storage = (Storage_MySQL)this.instance.getStorage();
        Map<String, Long> players = storage.getVanishedPlayersInfo();
        long time_now = System.currentTimeMillis();
        IntegrationsManager manager = this.instance.getManagers().getIntegrationsManager();
        for (Map.Entry<String, Long> entry : players.entrySet()) {
            String player_name = entry.getKey();
            long time = entry.getValue();
            if (time_now - time > 15000L) {
                manager.removeVanishedSomewhere(player_name);
                continue;
            }
            manager.addVanishedSomewhere(player_name);
        }
    }
}

