/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.ConsoleSenderTempData;
import pl.mirotcz.privatemessages.velocity.data.PlayerTempData;

public class ConfirmCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public ConfirmCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_PMCONFIRM);
            return;
        }
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            switch (args[0].toUpperCase()) {
                case "DELETE": {
                    this.proceedDeletion(sender);
                    break;
                }
                default: {
                    this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_PMCONFIRM);
                    return;
                }
            }
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        ArrayList<String> complete = new ArrayList<String>();
        CommandSource sender = invocation.source();
        if (args.length == 1 && sender.hasPermission("pm.delete")) {
            complete.add("delete");
        }
        return complete;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.delete");
    }

    private void proceedDeletion(CommandSource sender) {
        List<Message> messages;
        if (!sender.hasPermission("pm.delete")) {
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            return;
        }
        PlayerTempData tempData = null;
        ConsoleSenderTempData consoleTempData = null;
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            tempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getUsername());
            messages = tempData.getMessagesAwaitingDeletionConfirmation();
        } else {
            consoleTempData = this.instance.getConsoleSenderTempData();
            messages = consoleTempData.getMessagesAwaitingDeletionConfirmation();
        }
        if (messages == null) {
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_DELETE_CONFIRMATION_NO_MESSAGES);
            return;
        }
        this.instance.getStorage().deleteMessages(messages);
        this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", String.valueOf(messages.size())));
        if (tempData != null) {
            tempData.setMessagesAwaitingDeletionConfirmation(null);
        }
        if (consoleTempData != null) {
            consoleTempData.setMessagesAwaitingDeletionConfirmation(null);
        }
    }
}

