/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.MessagesRetrievalResult;
import pl.mirotcz.privatemessages.velocity.data.PlayerTempData;
import pl.mirotcz.privatemessages.velocity.utils.MathUtils;
import pl.mirotcz.privatemessages.velocity.utils.StringUtils;

public class DeleteCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public DeleteCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            this.sendHelp(sender);
            return;
        }
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            StringBuilder expression = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                expression.append(args[i]);
                if (i + 1 >= args.length) continue;
                expression.append(" ");
            }
            MessagesRetrievalResult result = this.instance.getUtils().getMainUtils().getMessagesMatchingExpression(expression.toString());
            if (result.hasError()) {
                switch (result.getError()) {
                    case INVALID_DATETIME_FORMAT: {
                        this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_DATETIME_FORMAT.replaceAll("<format>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
                        break;
                    }
                    case INVALID_EXPRESSION: {
                        this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_EXPRESSION);
                        break;
                    }
                    case INVALID_MESSAGE_ID: {
                        this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_MESSAGE_ID);
                    }
                }
                return;
            }
            List<Message> messages = result.getMessages();
            if (messages.isEmpty()) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_DELETE_NO_MESSAGES);
                return;
            }
            if (this.instance.getSettings().MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION) {
                if (sender instanceof Player) {
                    Player pl = (Player)sender;
                    PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getUsername());
                    tempData.setMessagesAwaitingDeletionConfirmation(messages);
                } else {
                    this.instance.getConsoleSenderTempData().setMessagesAwaitingDeletionConfirmation(messages);
                }
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_DELETE_CONFIRMATION_REQUIRED.replaceAll("<number>", String.valueOf(messages.size())));
                return;
            }
            this.instance.getStorage().deleteMessages(messages);
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", String.valueOf(messages.size())));
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        ArrayList<String> complete = new ArrayList<String>();
        if (args.length == 1) {
            complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAMES_PAIR);
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_ID);
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_IDS_GROUP);
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("before") || args[0].equalsIgnoreCase("after") || args[0].equalsIgnoreCase("since") || args[0].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[0].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (!MathUtils.isInteger(args[0]) && !args[0].equalsIgnoreCase("ALL")) {
                complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
            }
        } else if (args.length == 3) {
            if (args[1].equalsIgnoreCase("before") || args[1].equalsIgnoreCase("after") || args[1].equalsIgnoreCase("since") || args[1].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[1].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (args[0].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
            }
        } else if (args.length == 4 && args[1].equalsIgnoreCase("range")) {
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
        }
        return complete;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.delete");
    }

    private void sendHelp(CommandSource source) {
        for (String line : this.instance.getMessages().HELP_COMMAND_PMDELETE) {
            this.instance.getMessenger().send(source, line.replaceAll("<datetimeformat>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
        }
    }
}

