/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;
import pl.mirotcz.privatemessages.velocity.events.PlayerSettingsModifyEvent;

public class IgnoreCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public IgnoreCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            if (args.length != 1) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_IGNORE);
                return;
            }
            String name = args[0];
            Player pl = (Player)sender;
            PlayerSettings settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUsername());
            Set<String> ignored = settings.getIgnoredPlayers();
            if (ignored.contains(name)) {
                ignored.remove(name);
                this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_PLAYER_NOW_NOT_IGNORED.replaceAll("<player>", name));
            } else {
                ignored.add(name);
                this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_PLAYER_NOW_IGNORED.replaceAll("<player>", name));
            }
            settings.setIgnoredPlayers(ignored);
            this.instance.getServer().getEventManager().fireAndForget((Object)new PlayerSettingsModifyEvent(settings));
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        ArrayList<String> completions = new ArrayList<String>();
        String[] args = (String[])invocation.arguments();
        CommandSource sender = invocation.source();
        if (!sender.hasPermission("pm.ignore")) {
            return completions;
        }
        if (args.length == 0) {
            return this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, null);
        }
        if (args.length == 1) {
            return this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, args[0]);
        }
        if (completions.isEmpty()) {
            completions.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
        }
        return completions;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.ignore");
    }
}

