/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.HashSet;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;

public class IgnoredCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public IgnoredCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            if (args.length != 0) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_IGNORED);
                return;
            }
            Player pl = (Player)sender;
            PlayerSettings settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUsername());
            HashSet<String> ignored = new HashSet<String>(settings.getIgnoredPlayers());
            if (this.instance.getSettings().ESSENTIALS_IGNORE_RESPECT) {
                ignored.addAll(this.instance.getManagers().getIntegrationsManager().getIgnoredOnEssentials(pl.getUsername()));
            }
            this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_IGNORED_PLAYERS.replaceAll("<ignored>", ((Object)ignored).toString()));
        }).schedule();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.ignore");
    }
}

