/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.ArrayList;
import java.util.List;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;

public class MigrateCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public MigrateCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (args.length < 2) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_PMMIGRATE);
                return;
            }
            String oldName = args[0];
            String newName = args[1];
            boolean force = args.length >= 3 && args[2].equals("--force");
            PlayerSettings oldPlayerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(oldName);
            if (oldPlayerSettings == null) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_NO_PLAYER_DATA.replaceAll("<player>", oldName));
                return;
            }
            if (this.instance.getManagers().getPlayerSettingsManager().playerSettingsExists(newName) && !force) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_DATA_EXISTS.replaceAll("<player>", newName));
                return;
            }
            List<Message> newNameMessages = this.instance.getStorage().getMessagesFromHistory(newName);
            if (!newNameMessages.isEmpty() && !force) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_PLAYER_DATA_EXISTS.replaceAll("<player>", newName));
                return;
            }
            this.instance.getManagers().getPlayerSettingsManager().removePlayerData(oldName);
            oldPlayerSettings.setPlayerName(newName);
            this.instance.getStorage().removePlayerSettings(newName);
            this.instance.getStorage().removePlayerMessages(newName);
            this.instance.getStorage().savePlayerSettings(oldPlayerSettings);
            List<Message> oldNameMessages = this.instance.getStorage().getMessagesFromHistory(oldName);
            if (!oldNameMessages.isEmpty()) {
                oldNameMessages.forEach(message -> {
                    if (message.getSenderName().equalsIgnoreCase(oldName)) {
                        message.setSenderName(newName);
                    } else {
                        message.setRecipientName(newName);
                    }
                });
                oldNameMessages.forEach(message -> this.instance.getStorage().saveMessage((Message)message));
            }
            List<Message> pending_messages = this.instance.getManagers().getPendingMessagesManager().getPendingMessages();
            pending_messages.forEach(message -> {
                if (message.getSenderName().equalsIgnoreCase(oldName)) {
                    message.setSenderName(newName);
                } else {
                    message.setRecipientName(newName);
                }
            });
            List<Message> pending_offline_messages = this.instance.getManagers().getPendingMessagesManager().getPendingUnreadMessages();
            pending_offline_messages.forEach(message -> {
                if (message.getSenderName().equalsIgnoreCase(oldName)) {
                    message.setSenderName(newName);
                } else {
                    message.setRecipientName(newName);
                }
            });
            List<Message> unread_messages = this.instance.getStorage().getUnreadMessagesWithRecipient(oldName);
            unread_messages.forEach(message -> message.setRecipientName(newName));
            unread_messages.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            List<Message> unread_messages_sender = this.instance.getStorage().getUnreadMessagesWithSender(oldName);
            unread_messages_sender.forEach(message -> message.setSenderName(newName));
            unread_messages_sender.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MIGRATE_SUCCESS.replaceAll("<oldName>", oldName).replaceAll("<newName>", newName));
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        CommandSource sender = invocation.source();
        List<String> complete = new ArrayList<String>();
        if (!sender.hasPermission("pm.migrate")) {
            return complete;
        }
        if (args.length == 1) {
            complete = this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, args[0]);
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            }
        } else if (args.length == 2) {
            complete = this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, args[1]);
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            }
        } else if (args.length == 3 && sender.hasPermission("pm.migrate.force") && complete.size() == 0) {
            complete.add("--force");
        }
        return complete;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.migrate");
    }
}

