/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;
import pl.mirotcz.privatemessages.velocity.data.PlayerTempData;
import pl.mirotcz.privatemessages.velocity.events.PlayerSettingsModifyEvent;
import pl.mirotcz.privatemessages.velocity.utils.MathUtils;

public class ReadCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public ReadCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            if (args.length != 1) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_PMREAD);
                return;
            }
            if (!MathUtils.isInteger(args[0])) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_INVALID_NUMBER);
                return;
            }
            int number = Integer.parseInt(args[0]);
            List<Message> stored_messages = this.instance.getStorage().getUnreadMessagesWithRecipient(pl.getUsername());
            List<Message> all_pending_messages = this.instance.getManagers().getPendingMessagesManager().getPendingUnreadMessages();
            ArrayList<Message> all_messages = new ArrayList<Message>();
            for (int i = all_pending_messages.size() - 1; i >= 0; --i) {
                Message m = all_pending_messages.get(i);
                if (!m.getRecipientName().equalsIgnoreCase(pl.getUsername())) continue;
                all_messages.add(m);
            }
            all_messages.addAll(stored_messages);
            if (all_messages.isEmpty()) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_NO_MESSAGES);
                return;
            }
            if (all_messages.size() < number) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGE_NOT_FOUND);
                return;
            }
            Message message = (Message)all_messages.get(number - 1);
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGE_READ_NUMBER.replaceAll("<number>", String.valueOf(number)));
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGE_READ_SENDER.replaceAll("<sender>", message.getSenderName()));
            this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_MESSAGE_READ_MESSAGE.replaceAll("<message>", message.getMessageContent()));
            PlayerSettings player_settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUsername());
            if (this.instance.getSettings().PLUGIN_TIPS && player_settings.arePluginTipsEnabled()) {
                if (this.instance.getSettings().PLUGIN_TIPS_MODE == 1) {
                    PlayerTempData recipientTempData = this.instance.getManagers().getPlayerTempDataManger().getData(pl.getUsername());
                    if (!recipientTempData.hasReceivedPmClearTip()) {
                        this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_CLEAR_MESSAGES_TIP);
                        recipientTempData.setReceivedPmClearTip(true);
                    }
                } else {
                    PlayerSettings recipientSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUsername());
                    int unreadMessagesTipsCount = recipientSettings.getUnreadMessagesTipsCount();
                    if (unreadMessagesTipsCount < 1) {
                        this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_CLEAR_MESSAGES_TIP);
                        recipientSettings.setUnreadMessagesTipsCount(unreadMessagesTipsCount + 1);
                        this.instance.getServer().getEventManager().fireAndForget((Object)new PlayerSettingsModifyEvent(recipientSettings));
                    }
                }
            }
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        ArrayList<String> completions = new ArrayList<String>();
        String[] args = (String[])invocation.arguments();
        CommandSource sender = invocation.source();
        if (!sender.hasPermission("pm.read")) {
            return completions;
        }
        if (args.length == 0 || args[0] == null || args[0].isEmpty()) {
            return new ArrayList<String>(Arrays.asList(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_NUMBER));
        }
        return completions;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.read");
    }
}

