/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerTempData;

public class ReplyCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public ReplyCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (args.length < 1) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().HELP_COMMAND_REPLY);
                return;
            }
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player senderPlayer = (Player)sender;
            PlayerTempData data = this.instance.getManagers().getPlayerTempDataManger().getData(senderPlayer.getUsername());
            if (data.getLastMessageSender() == null) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_NONE_TO_REPLY);
                return;
            }
            Player lastMessageSender = this.instance.getServer().getPlayer(data.getLastMessageSender()).orElse(null);
            String recipientName = data.getLastMessageSender();
            boolean offline = false;
            boolean vanish = false;
            boolean known_player_name = false;
            if (lastMessageSender == null || !lastMessageSender.isActive()) {
                if (!this.instance.getSettings().ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS || !this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                    this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_OFFLINE_MESSAGING_DISABLED);
                    return;
                }
                String known_valid_player_name = this.instance.getManagers().getKnownPlayersManager().getKnownPlayer(recipientName);
                if (known_valid_player_name != null) {
                    recipientName = known_valid_player_name;
                    known_player_name = true;
                }
                offline = true;
            } else {
                recipientName = lastMessageSender.getUsername();
                if (this.instance.getManagers().getIntegrationsManager().isVanishSupported()) {
                    if (this.instance.getManagers().getIntegrationsManager().getVanish().isVanished(lastMessageSender)) {
                        vanish = true;
                    }
                } else if (this.instance.getManagers().getIntegrationsManager().isVanishedSomewhere(recipientName)) {
                    vanish = true;
                }
            }
            this.instance.getMessageSending().sendMessage(sender, lastMessageSender, recipientName, known_player_name, offline, vanish, args);
        }).schedule();
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        ArrayList<String> completions = new ArrayList<String>();
        String[] args = (String[])invocation.arguments();
        CommandSource sender = invocation.source();
        if (!sender.hasPermission("pm.reply")) {
            return completions;
        }
        if (args.length == 0 || args[0].isEmpty()) {
            return new ArrayList<String>(Arrays.asList(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_TEXT));
        }
        return completions;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.reply");
    }
}

