/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;
import pl.mirotcz.privatemessages.velocity.events.PlayerSettingsModifyEvent;

public class TipsCommand
implements SimpleCommand {
    private PrivateMessages instance;

    public TipsCommand(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().send(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            PlayerSettings settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUsername());
            if (settings.arePluginTipsEnabled()) {
                settings.setPluginTipsEnabled(false);
                this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_TIPS_NOW_DISABLED);
            } else {
                settings.setPluginTipsEnabled(true);
                this.instance.getMessenger().send((CommandSource)pl, this.instance.getMessages().INFO_TIPS_NOW_ENABLED);
            }
            this.instance.getServer().getEventManager().fireAndForget((Object)new PlayerSettingsModifyEvent(settings));
        }).schedule();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("pm.tips");
    }
}

