/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;

public class PluginMessagesListener {
    private PrivateMessages instance;
    public static final MinecraftChannelIdentifier SOUND_CHANNEL_IDENTIFIER = MinecraftChannelIdentifier.from((String)"pm:sound");

    public PluginMessagesListener(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void load() {
        this.instance.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{SOUND_CHANNEL_IDENTIFIER});
    }

    public void sendMessage(String message, String server_name, String channel_name) {
        RegisteredServer server = this.instance.getServer().getServer(server_name).orElse(null);
        if (server == null) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            out.writeUTF(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)channel_name), stream.toByteArray());
    }

    public void sendSoundNotify(String player_name) {
        Player pl = this.instance.getServer().getPlayer(player_name).orElse(null);
        if (pl == null) {
            return;
        }
        ServerConnection server = pl.getCurrentServer().orElse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            out.writeUTF(player_name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.getServer().sendPluginMessage((ChannelIdentifier)SOUND_CHANNEL_IDENTIFIER, stream.toByteArray());
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent ev) {
    }
}

