/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.vanish.Vanish;
import pl.mirotcz.privatemessages.velocity.vanish.Vanish_PremiumVanish;

public class IntegrationsManager {
    private Vanish vanish = null;
    private PrivateMessages instance = null;
    private volatile List<String> backend_vanished_names = new ArrayList<String>();
    private static final String PREMIUMVANISH_PLUGIN = "PremiumVanish";
    private String used_vanish_plugin_name = null;
    private Map<String, List<String>> essentials_ignores = new HashMap<String, List<String>>();
    private ScheduledTask essentials_ignores_task = null;

    public IntegrationsManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public boolean setupVanish() {
        if (this.instance.getServer().getPluginManager().getPlugin(PREMIUMVANISH_PLUGIN).isPresent()) {
            try {
                this.vanish = new Vanish_PremiumVanish();
                this.used_vanish_plugin_name = PREMIUMVANISH_PLUGIN;
                return true;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(PREMIUMVANISH_PLUGIN);
            }
        }
        return false;
    }

    public Vanish getVanish() {
        return this.vanish;
    }

    public boolean isVanishSupported() {
        return this.vanish != null;
    }

    public String getUsedVanishPluginName() {
        return this.used_vanish_plugin_name;
    }

    public boolean isVanishedSomewhere(String player_name) {
        return this.backend_vanished_names.contains(player_name);
    }

    public void addVanishedSomewhere(String player_name) {
        if (!this.backend_vanished_names.contains(player_name)) {
            this.backend_vanished_names.add(player_name);
        }
    }

    public synchronized void addVanishedSomewhere(List<String> names) {
        for (String name : names) {
            if (this.isVanishedSomewhere(name)) continue;
            this.addVanishedSomewhere(name);
        }
    }

    public void removeVanishedSomewhere(String player_name) {
        if (this.backend_vanished_names.contains(player_name)) {
            this.backend_vanished_names.remove(player_name);
        }
    }

    private void sendVanishHookErrorMessages(String pluginName) {
        this.instance.getLogger().warn("PrivateMessages tried to hook into " + pluginName + " plugin but it looks like it hasn't loaded properly.");
        this.instance.getLogger().warn("Check for error messages related to " + pluginName + " plugin and fix all found issues.");
        this.instance.getLogger().warn("PrivateMessages will continue working and try to hook into other present vanish plugins.");
    }

    public Map<String, List<String>> getEssentialsIgnores() {
        return this.essentials_ignores;
    }

    public List<String> getIgnoredOnEssentials(String ignoring) {
        if (this.essentials_ignores != null && this.essentials_ignores.containsKey(ignoring)) {
            return this.essentials_ignores.get(ignoring);
        }
        return new ArrayList<String>();
    }

    public void startEssentialsIgnoresUpdaterTask() {
        this.essentials_ignores_task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> this.loadEssentialsIgnores()).delay(Duration.ofSeconds(3L)).repeat(10L, TimeUnit.SECONDS).schedule();
    }

    public void stopEssentialsIgnoresUpdaterTask() {
        if (this.essentials_ignores_task != null) {
            this.essentials_ignores_task.cancel();
        }
    }

    private void loadEssentialsIgnores() {
        this.essentials_ignores = this.instance.getStorage().getAllEssentialsIgnores();
    }
}

