/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.managers.PluginConfig;

public class KnownPlayersManager {
    private List<String> known_names = new ArrayList<String>();
    private ScheduledTask task;
    private PrivateMessages instance;

    public KnownPlayersManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void loadNames(PluginConfig config) {
        this.known_names = config.getStringList("Names");
    }

    public boolean isKnownPlayerExact(String name) {
        return this.known_names.contains(name);
    }

    public String getKnownPlayer(String name) {
        for (String k_name : this.known_names) {
            if (!k_name.equalsIgnoreCase(name)) continue;
            return k_name;
        }
        return null;
    }

    public void addKnownPlayer(String name) {
        this.known_names.add(name);
    }

    public void saveKnownPlayers(PluginConfig config) {
        config.setStringList("Names", this.known_names);
        config.save();
    }

    public void startTask() {
        this.task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> this.saveKnownPlayers(this.instance.getManagers().getConfigManagers().getKnownPlayersConfigManager())).delay(10L, TimeUnit.SECONDS).repeat(10L, TimeUnit.SECONDS).schedule();
    }

    public void stopTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

