/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import com.velocitypowered.api.proxy.ProxyServer;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.listeners.PlayerDisconnectListener;
import pl.mirotcz.privatemessages.velocity.listeners.PlayerSettingsModifyListener;
import pl.mirotcz.privatemessages.velocity.listeners.PluginMessagesListener;
import pl.mirotcz.privatemessages.velocity.listeners.PostLoginListener;
import pl.mirotcz.privatemessages.velocity.listeners.PremiumVanishListener;
import pl.mirotcz.privatemessages.velocity.listeners.PrivateMessageListener;
import pl.mirotcz.privatemessages.velocity.vanish.Vanish_PremiumVanish;

public class ListenersManager {
    private PrivateMessages instance;
    private PostLoginListener postLoginListener;
    private PlayerDisconnectListener playerDisconnectListener;
    private PlayerSettingsModifyListener playerSettingsModifyListener;
    private PrivateMessageListener privateMessageListener;
    private PremiumVanishListener premiumVanishListener;
    private PluginMessagesListener pluginMessagesListener;

    public ListenersManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public PostLoginListener getPostLoginListener() {
        return this.postLoginListener;
    }

    public PlayerDisconnectListener getPlayerDisconnectListener() {
        return this.playerDisconnectListener;
    }

    public PlayerSettingsModifyListener getPlayerSettingsModifyListener() {
        return this.playerSettingsModifyListener;
    }

    public PrivateMessageListener getPrivateMessageListener() {
        return this.privateMessageListener;
    }

    public PremiumVanishListener getPremiumVanishListener() {
        return this.premiumVanishListener;
    }

    public PluginMessagesListener getPluginMessagesListener() {
        return this.pluginMessagesListener;
    }

    public void setupListeners() {
        this.postLoginListener = new PostLoginListener(this.instance);
        this.playerDisconnectListener = new PlayerDisconnectListener(this.instance);
        this.playerSettingsModifyListener = new PlayerSettingsModifyListener(this.instance);
        this.privateMessageListener = new PrivateMessageListener(this.instance);
        this.pluginMessagesListener = new PluginMessagesListener(this.instance);
        this.pluginMessagesListener.load();
        ProxyServer server = this.instance.getServer();
        server.getEventManager().register((Object)this.instance, (Object)this.pluginMessagesListener);
        server.getEventManager().register((Object)this.instance, (Object)this.postLoginListener);
        server.getEventManager().register((Object)this.instance, (Object)this.playerDisconnectListener);
        server.getEventManager().register((Object)this.instance, (Object)this.playerSettingsModifyListener);
        server.getEventManager().register((Object)this.instance, (Object)this.privateMessageListener);
        if (this.instance.getVanish() instanceof Vanish_PremiumVanish) {
            this.premiumVanishListener = new PremiumVanishListener(this.instance);
            server.getEventManager().register((Object)this.instance, (Object)this.premiumVanishListener);
        }
    }
}

