/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.managers.CommandsManager;
import pl.mirotcz.privatemessages.velocity.managers.ConfigManagers;
import pl.mirotcz.privatemessages.velocity.managers.IntegrationsManager;
import pl.mirotcz.privatemessages.velocity.managers.KnownPlayersManager;
import pl.mirotcz.privatemessages.velocity.managers.ListenersManager;
import pl.mirotcz.privatemessages.velocity.managers.MessagesManager;
import pl.mirotcz.privatemessages.velocity.managers.PendingMessagesManager;
import pl.mirotcz.privatemessages.velocity.managers.PlayerSettingsManager;
import pl.mirotcz.privatemessages.velocity.managers.PlayerTempDataManager;
import pl.mirotcz.privatemessages.velocity.managers.SettingsManager;
import pl.mirotcz.privatemessages.velocity.managers.StorageManager;

public class Managers {
    private ConfigManagers configManagers;
    private PlayerSettingsManager playerSettingsManager;
    private ListenersManager listenersManager;
    private StorageManager storageManager;
    private SettingsManager settingsManager;
    private MessagesManager messagesManager;
    private PendingMessagesManager pendingMessagesManager;
    private PlayerTempDataManager playerTempDataManager;
    private IntegrationsManager integrationsManager;
    private KnownPlayersManager knownPlayersManager;
    private CommandsManager commandManager;
    private PrivateMessages instance;

    public Managers(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void load() {
        this.configManagers = new ConfigManagers(this.instance);
        this.configManagers.setupConfigs();
        this.knownPlayersManager = new KnownPlayersManager(this.instance);
        this.knownPlayersManager.loadNames(this.configManagers.getKnownPlayersConfigManager());
        this.knownPlayersManager.startTask();
        this.messagesManager = new MessagesManager();
        this.messagesManager.load(this.configManagers.getLangConfigManager());
        this.settingsManager = new SettingsManager();
        this.settingsManager.load(this.configManagers.getMainConfigManager());
        this.storageManager = new StorageManager(this.instance);
        this.storageManager.setupStorage();
        this.playerSettingsManager = new PlayerSettingsManager(this.instance);
        this.playerSettingsManager.load();
        this.playerSettingsManager.registerSaveTask();
        this.integrationsManager = new IntegrationsManager(this.instance);
        this.integrationsManager.setupVanish();
        this.integrationsManager.startEssentialsIgnoresUpdaterTask();
        this.listenersManager = new ListenersManager(this.instance);
        this.listenersManager.setupListeners();
        this.pendingMessagesManager = new PendingMessagesManager(this.instance);
        this.pendingMessagesManager.startSaveTask();
        this.playerTempDataManager = new PlayerTempDataManager();
        this.commandManager = new CommandsManager(this.instance);
        this.commandManager.registerCommands();
    }

    public ConfigManagers getConfigManagers() {
        return this.configManagers;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public PendingMessagesManager getPendingMessagesManager() {
        return this.pendingMessagesManager;
    }

    public PlayerTempDataManager getPlayerTempDataManger() {
        return this.playerTempDataManager;
    }

    public IntegrationsManager getIntegrationsManager() {
        return this.integrationsManager;
    }

    public KnownPlayersManager getKnownPlayersManager() {
        return this.knownPlayersManager;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }
}

