/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;

public class PendingMessagesManager {
    private List<Message> pending_messages = new ArrayList<Message>();
    private List<Message> pending_unread_messages = new ArrayList<Message>();
    private PrivateMessages instance = null;
    private ScheduledTask task = null;

    public PendingMessagesManager(PrivateMessages plugin) {
        this.instance = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getPendingMessages() {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            return this.pending_messages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            if (!this.pending_messages.contains(message)) {
                this.pending_messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getPendingUnreadMessages() {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            return this.pending_unread_messages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingUnreadMessage(Message message) {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            if (!this.pending_unread_messages.contains(message)) {
                this.pending_unread_messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.remove(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingUnreadMessage(Message message) {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            if (this.pending_unread_messages.contains(message)) {
                this.pending_unread_messages.remove(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingMessagesToStorage() {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.forEach(message -> this.instance.getStorage().saveMessage((Message)message));
            this.pending_messages = new ArrayList<Message>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingUnreadMessagesToStorage() {
        List<Message> list = this.pending_unread_messages;
        synchronized (list) {
            this.pending_unread_messages.forEach(message -> this.instance.getStorage().saveUnreadMessage((Message)message));
            this.pending_unread_messages = new ArrayList<Message>();
        }
    }

    public void startSaveTask() {
        this.task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            this.savePendingMessagesToStorage();
            this.savePendingUnreadMessagesToStorage();
        }).delay((long)this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS, TimeUnit.SECONDS).repeat((long)this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS, TimeUnit.SECONDS).schedule();
    }

    public void cancelSaveTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

