/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.PlayerSettings;

public class PlayerSettingsManager {
    private Map<String, PlayerSettings> playerSettings = new ConcurrentHashMap<String, PlayerSettings>();
    private volatile BlockingQueue<PlayerSettings> pendingChanges = new ArrayBlockingQueue<PlayerSettings>(256);
    private ScheduledTask registeredTask = null;
    private PrivateMessages instance;

    public PlayerSettingsManager(PrivateMessages plugin) {
        this.playerSettings = new ConcurrentHashMap<String, PlayerSettings>();
        this.instance = plugin;
    }

    public void load() {
        this.playerSettings = this.instance.getStorage().loadAllPlayerSettings();
    }

    public PlayerSettings getPlayerSettings(String playerName) {
        if (this.playerSettings.containsKey(playerName)) {
            return this.playerSettings.get(playerName);
        }
        this.createNewSettings(playerName);
        PlayerSettings settings = this.playerSettings.get(playerName);
        return settings;
    }

    public void addPendingChanges(String playerName) {
        if (!this.pendingChanges.contains(this.getPlayerSettings(playerName))) {
            this.pendingChanges.add(this.getPlayerSettings(playerName));
        }
    }

    public void addPendingChanges(PlayerSettings data) {
        if (!this.pendingChanges.contains(data)) {
            this.pendingChanges.add(data);
        }
    }

    public Map<String, PlayerSettings> getAllSettings() {
        return this.playerSettings;
    }

    public synchronized void addPlayerSettings(String playerName, PlayerSettings settings) {
        this.playerSettings.put(playerName, settings);
    }

    public synchronized void createNewSettings(String player_name) {
        PlayerSettings settings = new PlayerSettings();
        settings.setPlayerName(player_name);
        this.playerSettings.put(player_name, settings);
        this.pendingChanges.add(settings);
    }

    public synchronized void removePlayerData(PlayerSettings settings) {
        Iterator<Map.Entry<String, PlayerSettings>> it = this.playerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PlayerSettings> entry = it.next();
            if (entry.getValue() != settings) continue;
            it.remove();
            return;
        }
    }

    public synchronized void removePlayerData(String name) {
        Iterator<Map.Entry<String, PlayerSettings>> it = this.playerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PlayerSettings> entry = it.next();
            if (!entry.getValue().getPlayerName().equalsIgnoreCase(name)) continue;
            it.remove();
            return;
        }
    }

    public boolean playerSettingsExists(String playerName) {
        return this.playerSettings.containsKey(playerName);
    }

    public void savePendingChanges() {
        ArrayBlockingQueue<PlayerSettings> queue = new ArrayBlockingQueue<PlayerSettings>(256);
        queue.addAll(this.pendingChanges);
        ArrayList<String> already_saved = new ArrayList<String>();
        for (PlayerSettings data : queue) {
            if (already_saved.stream().anyMatch(x -> x.equalsIgnoreCase(data.getPlayerName()))) continue;
            this.instance.getStorage().savePlayerSettings(data);
            this.instance.getStorage().addPlayerWatingForSettingsReload(data.getPlayerName());
            already_saved.add(data.getPlayerName());
        }
        queue.clear();
        this.pendingChanges.clear();
    }

    public void registerSaveTask() {
        this.registeredTask = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> this.savePendingChanges()).delay(10L, TimeUnit.SECONDS).repeat(10L, TimeUnit.SECONDS).schedule();
    }

    public void cancelSaveTask() {
        if (this.registeredTask != null) {
            this.registeredTask.cancel();
        }
    }
}

