/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import pl.mirotcz.privatemessages.velocity.managers.ConfigurationSection;

public class PluginConfig {
    private String sourceFileName;
    private String targetFileName;
    private Path dataPath;
    private Yaml yaml;
    private Map<String, Object> data;

    public PluginConfig(String sourceFileName, Path dataPath) {
        this(sourceFileName, sourceFileName, dataPath);
    }

    public PluginConfig(String sourceFileName, String targetFileName, Path dataPath) {
        this.sourceFileName = sourceFileName;
        this.targetFileName = targetFileName;
        this.dataPath = dataPath;
    }

    public void load() {
        Path targetPath;
        if (Files.notExists(this.dataPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.dataPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.notExists(targetPath = this.dataPath.resolve(this.targetFileName), new LinkOption[0])) {
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.sourceFileName);){
                Files.copy(stream, targetPath, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(targetPath.normalize().toString()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.yaml = new Yaml();
        this.data = (Map)this.yaml.load((InputStream)inputStream);
    }

    private Yaml getYaml() {
        return this.yaml;
    }

    public void save() {
        Path configPath = this.dataPath.resolve(this.targetFileName);
        try (FileWriter writer = new FileWriter(configPath.normalize().toString());){
            this.getYaml().dump(this.data, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean getBoolean(String key) {
        if (this.data.containsKey(key)) {
            return Boolean.valueOf(String.valueOf(this.data.getOrDefault(key, false)));
        }
        return false;
    }

    public void setBoolean(String key, Boolean value) {
        this.data.put(key, value);
    }

    public String getString(String key) {
        if (this.data.containsKey(key)) {
            return String.valueOf(this.data.getOrDefault(key, ""));
        }
        return null;
    }

    public void setString(String key, String value) {
        this.data.put(key, value);
    }

    public List<String> getStringList(String key) {
        if (this.data.containsKey(key)) {
            return this.data.getOrDefault(key, new ArrayList());
        }
        return null;
    }

    public void setStringList(String key, List<String> list) {
        this.data.put(key, list);
    }

    public Integer getInteger(String key) {
        if (this.data.containsKey(key)) {
            return Integer.parseInt(String.valueOf(this.data.getOrDefault(key, 0)));
        }
        return 0;
    }

    public void setInteger(String key, Integer value) {
        this.data.put(key, value);
    }

    public Long getLong(String key) {
        if (this.data.containsKey(key)) {
            return Long.parseLong(String.valueOf(this.data.getOrDefault(key, 0)));
        }
        return 0L;
    }

    public void setLong(String key, Long value) {
        this.data.put(key, value);
    }

    public Float getFloat(String key) {
        if (this.data.containsKey(key)) {
            return Float.valueOf(Float.parseFloat(String.valueOf(this.data.getOrDefault(key, 0))));
        }
        return Float.valueOf(0.0f);
    }

    public void setFloat(String key, Integer value) {
        this.data.put(key, value);
    }

    public Double getDouble(String key) {
        if (this.data.containsKey(key)) {
            return Double.parseDouble(String.valueOf(this.data.getOrDefault(key, 0)));
        }
        return 0.0;
    }

    public void setDouble(String key, Double value) {
        this.data.put(key, value);
    }

    public ConfigurationSection getSection(String key) {
        Map<String, Object> sectionData;
        if (key.contains(".")) {
            String[] keys = key.split(".");
            for (int i = 0; i < keys.length; ++i) {
                String string = keys[i];
            }
        }
        if (this.data.containsKey(key)) {
            sectionData = this.data.getOrDefault(key, new HashMap());
            if (sectionData == null) {
                sectionData = new HashMap();
            }
        } else {
            sectionData = new HashMap<String, Object>();
        }
        return new ConfigurationSection(sectionData);
    }

    public void setSection(String key, Map<String, Object> map) {
        this.data.put(key, map);
    }

    public Map<String, Object> getNestedValueMap(String ... keys) {
        Object value = this.data;
        for (String key : keys) {
            if (!(value instanceof Map)) {
                return null;
            }
            value = value.get(key);
        }
        return value instanceof Map ? value : null;
    }

    public void overwriteNestedMap(Map<String, Object> newSubMap, String ... keys) {
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            HashMap next = current.get(keys[i]);
            if (!(next instanceof Map)) {
                next = new HashMap();
                current.put(keys[i], next);
            }
            current = next;
        }
        current.put((String)keys[keys.length - 1], newSubMap);
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }
}

