/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.managers;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.mirotcz.privatemessages.velocity.managers.ConfigurationSection;
import pl.mirotcz.privatemessages.velocity.managers.PluginConfig;

public class SettingsManager {
    public String STORAGE_TYPE;
    public String DB_HOST;
    public String DB_NAME;
    public String DB_USER;
    public String DB_PASS;
    public int DB_PORT;
    public List<DateTimeFormatter> IN_COMMAND_DATETIME_FORMATTERS;
    public String TIME_ZONE;
    public int MESSAGE_SAVE_INTERVAL_SECONDS = 10;
    public boolean MESSAGES_HISTORY_ENABLED = true;
    public boolean ALLOW_SENDING_MESSAGES_TO_SELF = true;
    public boolean ALLOW_REPLYING_TO_CONSOLE = true;
    public boolean ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS = true;
    public boolean SPY_IN_CONSOLE = false;
    public boolean METRICS = true;
    public boolean NOTIFY_UNREAD_MESSAGES_AFTER_JOIN = true;
    public boolean NOTIFY_UNREAD_MESSAGES_AFTER_UNVANISH = true;
    public boolean PLUGIN_TIPS = true;
    public int PLUGIN_TIPS_MODE = 1;
    public boolean ESSENTIALS_IGNORE_RESPECT = true;
    public List<String> IN_COMMAND_DATETIME_FORMAT_PLAIN;
    public boolean MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = true;

    public void load(PluginConfig config) {
        ConfigurationSection storage_section = config.getSection("Storage");
        Map<String, Object> storage = storage_section.getMap();
        this.STORAGE_TYPE = String.valueOf(storage.get("type"));
        this.DB_HOST = String.valueOf(storage.get("hostname"));
        this.DB_NAME = String.valueOf(storage.get("database"));
        this.DB_USER = String.valueOf(storage.get("user"));
        this.DB_PASS = String.valueOf(storage.get("password"));
        this.DB_PORT = Integer.valueOf(String.valueOf(storage.get("port")));
        this.IN_COMMAND_DATETIME_FORMAT_PLAIN = config.getStringList("InCommandDateTimeFormat");
        this.IN_COMMAND_DATETIME_FORMATTERS = new ArrayList<DateTimeFormatter>();
        for (String formatPlain : this.IN_COMMAND_DATETIME_FORMAT_PLAIN) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(formatPlain).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
            this.IN_COMMAND_DATETIME_FORMATTERS.add(formatter);
        }
        this.ALLOW_SENDING_MESSAGES_TO_SELF = config.getBoolean("AllowSendingMessagesToSelf");
        this.ALLOW_SENDING_MESSAGES_TO_OFFLINE_PLAYERS = config.getBoolean("AllowSendingMessagesToOfflinePlayers");
        this.SPY_IN_CONSOLE = config.getBoolean("SpyInConsole");
        this.MESSAGE_SAVE_INTERVAL_SECONDS = config.getInteger("MessagesSaveIntervalSeconds");
        this.METRICS = config.getBoolean("Metrics");
        this.NOTIFY_UNREAD_MESSAGES_AFTER_JOIN = config.getBoolean("NotifyUnreadMessagesAfterJoin");
        this.NOTIFY_UNREAD_MESSAGES_AFTER_UNVANISH = config.getBoolean("NotifyUnreadMessagesAfterUnvanish");
        this.MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = config.getBoolean("MessagesDeletionByCommandRequiresConfirmation");
        ConfigurationSection msg_history_section = config.getSection("MessagesHistory");
        Map<String, Object> msg_history = msg_history_section.getMap();
        this.TIME_ZONE = config.containsKey("TimeZone") ? config.getString("TimeZone") : String.valueOf(msg_history.get("TimeZone"));
        this.MESSAGES_HISTORY_ENABLED = Boolean.valueOf(String.valueOf(msg_history.get("Enabled")));
        ConfigurationSection tips_section = config.getSection("PluginTips");
        Map<String, Object> tips = tips_section.getMap();
        this.PLUGIN_TIPS = Boolean.valueOf(String.valueOf(tips.get("Enabled")));
        this.PLUGIN_TIPS_MODE = Integer.valueOf(String.valueOf(tips.get("Mode")));
        this.PLUGIN_TIPS_MODE = this.PLUGIN_TIPS_MODE >= 1 && this.PLUGIN_TIPS_MODE <= 2 ? this.PLUGIN_TIPS_MODE : 1;
        ConfigurationSection integrations_section = config.getSection("Integration");
        Map essentials = (Map)integrations_section.getMap().get("Essentials");
        this.ESSENTIALS_IGNORE_RESPECT = (Boolean)essentials.get("RespectIgnore");
    }

    public void save(PluginConfig config) {
        config.setBoolean("SpyInConsole", this.SPY_IN_CONSOLE);
        config.save();
    }
}

